/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormatBase;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;

public class HadoopInputFormat<K, V>
extends HadoopInputFormatBase<K, V, Tuple2<K, V>>
implements ResultTypeQueryable<Tuple2<K, V>> {
    public HadoopInputFormat(InputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, Job job) {
        super(mapreduceInputFormat, key, value, job);
    }

    public Tuple2<K, V> nextRecord(Tuple2<K, V> record) throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        if (!this.hasNext) {
            return null;
        }
        try {
            record.f0 = this.recordReader.getCurrentKey();
            record.f1 = this.recordReader.getCurrentValue();
        }
        catch (InterruptedException e) {
            throw new IOException("Could not get KeyValue pair.", e);
        }
        this.fetched = false;
        return record;
    }

    @Override
    public TypeInformation<Tuple2<K, V>> getProducedType() {
        return new TupleTypeInfo(TypeExtractor.createTypeInfo(this.keyClass), TypeExtractor.createTypeInfo(this.valueClass));
    }
}

