/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapred.HadoopInputFormatBase;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;

public class HadoopInputFormat<K, V>
extends HadoopInputFormatBase<K, V, Tuple2<K, V>>
implements ResultTypeQueryable<Tuple2<K, V>> {
    public HadoopInputFormat(InputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, JobConf job) {
        super(mapredInputFormat, key, value, job);
    }

    public Tuple2<K, V> nextRecord(Tuple2<K, V> record) throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        if (!this.hasNext) {
            return null;
        }
        record.f0 = this.key;
        record.f1 = this.value;
        this.fetched = false;
        return record;
    }

    @Override
    public TypeInformation<Tuple2<K, V>> getProducedType() {
        return new TupleTypeInfo(TypeExtractor.createTypeInfo(this.keyClass), TypeExtractor.createTypeInfo(this.valueClass));
    }
}

