/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.twitter.chill.ScalaKryoInstantiator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class KryoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 2L;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;
    private transient DataOutputView previousOut;
    private transient DataInputView previousIn;
    private transient Input input;
    private transient Output output;

    public KryoSerializer(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("Type class cannot be null.");
        }
        this.type = type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    public T createInstance() {
        return null;
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.copy(from);
        }
        catch (KryoException ke) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baout);
            this.kryo.writeObject(output, from);
            output.close();
            ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
            Input input = new Input((InputStream)bain);
            return (T)this.kryo.readObject(input, from.getClass());
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (target != this.previousOut) {
            DataOutputViewStream outputStream = new DataOutputViewStream(target);
            this.output = new Output((OutputStream)outputStream);
            this.previousOut = target;
        }
        try {
            this.kryo.writeClassAndObject(this.output, record);
            this.output.flush();
        }
        catch (KryoException ke) {
            Throwable cause = ke.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw ke;
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        this.checkKryoInitialized();
        if (source != this.previousIn) {
            DataInputViewStream inputStream = new DataInputViewStream(source);
            this.input = new NoFetchingInput(inputStream);
            this.previousIn = source;
        }
        return (T)this.kryo.readClassAndObject(this.input);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
        T tmp = this.deserialize(this.copyInstance, source);
        this.serialize(tmp, target);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof KryoSerializer) {
            KryoSerializer other = (KryoSerializer)((Object)obj);
            return other.type == this.type;
        }
        return false;
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new ScalaKryoInstantiator().newKryo();
            this.kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
            this.kryo.setRegistrationRequired(false);
            this.kryo.register(this.type);
            this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    Kryo getKryo() {
        this.checkKryoInitialized();
        return this.kryo;
    }
}

