/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;

public final class TupleTypeInfo<T extends Tuple>
extends TupleTypeInfoBase<T> {
    private TypeComparator<?>[] fieldComparators;
    private int[] logicalKeyFields;
    private int comparatorHelperIndex = 0;
    private static final Class<?>[] CLASSES = new Class[]{Tuple1.class, Tuple2.class, Tuple3.class, Tuple4.class, Tuple5.class, Tuple6.class, Tuple7.class, Tuple8.class, Tuple9.class, Tuple10.class, Tuple11.class, Tuple12.class, Tuple13.class, Tuple14.class, Tuple15.class, Tuple16.class, Tuple17.class, Tuple18.class, Tuple19.class, Tuple20.class, Tuple21.class, Tuple22.class, Tuple23.class, Tuple24.class, Tuple25.class};

    public TupleTypeInfo(TypeInformation<?> ... types) {
        this(CLASSES[types.length - 1], types);
    }

    public TupleTypeInfo(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType, types);
        if (types == null || types.length == 0 || types.length > 25) {
            throw new IllegalArgumentException();
        }
    }

    public TupleSerializer<T> createSerializer() {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
        for (int i = 0; i < this.types.length; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer();
        }
        Class tupleClass = this.getTypeClass();
        return new TupleSerializer(tupleClass, fieldSerializers);
    }

    protected void initializeNewComparator(int localKeyCount) {
        this.fieldComparators = new TypeComparator[localKeyCount];
        this.logicalKeyFields = new int[localKeyCount];
        this.comparatorHelperIndex = 0;
    }

    protected void addCompareField(int fieldId, TypeComparator<?> comparator) {
        this.fieldComparators[this.comparatorHelperIndex] = comparator;
        this.logicalKeyFields[this.comparatorHelperIndex] = fieldId;
        ++this.comparatorHelperIndex;
    }

    protected TypeComparator<T> getNewComparator() {
        TypeComparator<?>[] finalFieldComparators = Arrays.copyOf(this.fieldComparators, this.comparatorHelperIndex);
        int[] finalLogicalKeyFields = Arrays.copyOf(this.logicalKeyFields, this.comparatorHelperIndex);
        int maxKey = 0;
        for (int key : finalLogicalKeyFields) {
            maxKey = Math.max(maxKey, key);
        }
        TypeSerializer[] fieldSerializers = new TypeSerializer[maxKey + 1];
        for (int i = 0; i <= maxKey; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer();
        }
        if (finalFieldComparators.length == 0 || finalLogicalKeyFields.length == 0 || fieldSerializers.length == 0 || finalFieldComparators.length != finalLogicalKeyFields.length) {
            throw new IllegalArgumentException("Tuple comparator creation has a bug");
        }
        return new TupleComparator(finalLogicalKeyFields, finalFieldComparators, fieldSerializers);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfo) {
            TupleTypeInfo other = (TupleTypeInfo)((Object)obj);
            return (this.tupleType == null && other.tupleType == null || this.tupleType.equals(other.tupleType)) && Arrays.deepEquals(this.types, other.types);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.types.hashCode() ^ Arrays.deepHashCode(this.types);
    }

    @Override
    public String toString() {
        return "Java " + super.toString();
    }

    public static <X extends Tuple> TupleTypeInfo<X> getBasicTupleTypeInfo(Class<?> ... basicTypes) {
        if (basicTypes == null || basicTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        TypeInformation[] infos = new TypeInformation[basicTypes.length];
        for (int i = 0; i < infos.length; ++i) {
            Class<?> type = basicTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Type at position " + i + " is null.");
            }
            BasicTypeInfo info = BasicTypeInfo.getInfoFor(type);
            if (info == null) {
                throw new IllegalArgumentException("Type at position " + i + " is not a basic type.");
            }
            infos[i] = info;
        }
        TupleTypeInfo tupleInfo = new TupleTypeInfo(infos);
        return tupleInfo;
    }
}

