/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;

public class ValueSerializer<T extends Value>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;

    public ValueSerializer(Class<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    public T createInstance() {
        return (T)((Value)InstantiationUtil.instantiate(this.type));
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Value)this.kryo.copy(from));
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Value)this.kryo.copy(from));
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (this.copyInstance == null) {
            this.copyInstance = (Value)InstantiationUtil.instantiate(this.type);
        }
        this.copyInstance.read(source);
        this.copyInstance.write(target);
    }

    private final void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    public int hashCode() {
        return this.type.hashCode() + 17;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ValueSerializer.class) {
            ValueSerializer other = (ValueSerializer)((Object)obj);
            return this.type == other.type;
        }
        return false;
    }
}

