/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class KryoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final Class<? extends T> typeToInstantiate;
    private transient Kryo kryo;
    private transient T copyInstance;
    private transient DataOutputView previousOut;
    private transient DataInputView previousIn;
    private transient Input input;
    private transient Output output;

    public KryoSerializer(Class<T> type) {
        this(type, type);
    }

    public KryoSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        if (type == null || typeToInstantiate == null) {
            throw new NullPointerException("Type class cannot be null.");
        }
        this.type = type;
        this.typeToInstantiate = typeToInstantiate;
        this.kryo = new Kryo();
        this.kryo.setAsmEnabled(true);
        this.kryo.register(type);
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    public T createInstance() {
        this.checkKryoInitialized();
        return (T)this.kryo.newInstance(this.typeToInstantiate);
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)this.kryo.copy(from);
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)this.kryo.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (target != this.previousOut) {
            DataOutputViewStream outputStream = new DataOutputViewStream(target);
            this.output = new Output((OutputStream)outputStream);
            this.previousOut = target;
        }
        this.kryo.writeObject(this.output, record);
        this.output.flush();
    }

    public T deserialize(DataInputView source) throws IOException {
        this.checkKryoInitialized();
        if (source != this.previousIn) {
            DataInputViewStream inputStream = new DataInputViewStream(source);
            this.input = new NoFetchingInput(inputStream);
            this.previousIn = source;
        }
        return (T)this.kryo.readObject(this.input, this.typeToInstantiate);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
        T tmp = this.deserialize(this.copyInstance, source);
        this.serialize(tmp, target);
    }

    public int hashCode() {
        return this.type.hashCode() + 31 * this.typeToInstantiate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof KryoSerializer) {
            KryoSerializer other = (KryoSerializer)((Object)obj);
            return other.type == this.type && other.typeToInstantiate == this.typeToInstantiate;
        }
        return false;
    }

    private final void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }
}

