/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.java.record.io.FileOutputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvOutputFormat
extends FileOutputFormat {
    private static final long serialVersionUID = 1L;
    public static final String RECORD_DELIMITER_PARAMETER = "output.record.delimiter";
    private static final String RECORD_DELIMITER_ENCODING = "output.record.delimiter-encoding";
    public static final String FIELD_DELIMITER_PARAMETER = "output.record.field-delimiter";
    public static final String NUM_FIELDS_PARAMETER = "output.record.num-fields";
    public static final String FIELD_TYPE_PARAMETER_PREFIX = "output.record.type_";
    public static final String RECORD_POSITION_PARAMETER_PREFIX = "output.record.position_";
    public static final String LENIENT_PARSING = "output.record.lenient";
    private static final Logger LOG = LoggerFactory.getLogger(CsvOutputFormat.class);
    private int numFields;
    private Class<? extends Value>[] classes;
    private int[] recordPositions;
    private Writer wrt;
    private String fieldDelimiter;
    private String recordDelimiter;
    private String charsetName;
    private boolean lenient;
    private boolean ctorInstantiation = false;

    public CsvOutputFormat() {
    }

    public CsvOutputFormat(Class<? extends Value> ... types) {
        this("\n", ",", types);
    }

    public CsvOutputFormat(String fieldDelimiter, Class<? extends Value> ... types) {
        this("\n", fieldDelimiter, types);
    }

    public CsvOutputFormat(String recordDelimiter, String fieldDelimiter, Class<? extends Value> ... types) {
        if (recordDelimiter == null) {
            throw new IllegalArgumentException("RecordDelmiter shall not be null.");
        }
        if (fieldDelimiter == null) {
            throw new IllegalArgumentException("FieldDelimiter shall not be null.");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("No field types given.");
        }
        this.fieldDelimiter = fieldDelimiter;
        this.recordDelimiter = recordDelimiter;
        this.lenient = false;
        this.setTypes(types);
        this.ctorInstantiation = true;
    }

    public void setTypes(Class<? extends Value> ... types) {
        this.classes = types;
        this.numFields = types.length;
        this.recordPositions = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) {
                throw new IllegalArgumentException("Invalid Constructor Parameter: No type class for parameter " + 2 * i);
            }
            this.recordPositions[i] = i;
        }
        if (this.fieldDelimiter == null) {
            this.fieldDelimiter = ",";
        }
        if (this.recordDelimiter == null) {
            this.recordDelimiter = "\n";
        }
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        int configNumFields = parameters.getInteger(NUM_FIELDS_PARAMETER, -1);
        if (this.ctorInstantiation) {
            if (configNumFields > 0) {
                throw new IllegalStateException("CsvOutputFormat instantiated via both parameters and config.");
            }
            return;
        }
        if (configNumFields < 1) {
            throw new IllegalStateException("CsvOutputFormat not configured via parameters or config.");
        }
        this.numFields = configNumFields;
        Class[] arr = new Class[this.numFields];
        this.classes = arr;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (int i = 0; i < this.numFields; ++i) {
                Class clazz = parameters.getClass(FIELD_TYPE_PARAMETER_PREFIX + i, null, cl);
                if (clazz == null) {
                    throw new IllegalArgumentException("Invalid configuration for CsvOutputFormat: No type class for parameter " + i);
                }
                this.classes[i] = clazz;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not resolve type classes", e);
        }
        this.recordPositions = new int[this.numFields];
        boolean anyRecordPosDefined = false;
        boolean allRecordPosDefined = true;
        for (int i = 0; i < this.numFields; ++i) {
            int pos = parameters.getInteger(RECORD_POSITION_PARAMETER_PREFIX + i, Integer.MIN_VALUE);
            if (pos != Integer.MIN_VALUE) {
                anyRecordPosDefined = true;
                if (pos < 0) {
                    throw new IllegalArgumentException("Invalid configuration for CsvOutputFormat: Invalid record position for parameter " + i);
                }
                this.recordPositions[i] = pos;
                continue;
            }
            allRecordPosDefined = false;
            this.recordPositions[i] = i;
        }
        if (anyRecordPosDefined && !allRecordPosDefined) {
            throw new IllegalArgumentException("Invalid configuration for CsvOutputFormat: Either none or all record positions must be defined.");
        }
        this.recordDelimiter = parameters.getString(RECORD_DELIMITER_PARAMETER, "\n");
        if (this.recordDelimiter == null) {
            throw new IllegalArgumentException("The delimiter in the DelimitedOutputFormat must not be null.");
        }
        this.charsetName = parameters.getString(RECORD_DELIMITER_ENCODING, null);
        this.fieldDelimiter = parameters.getString(FIELD_DELIMITER_PARAMETER, ",");
        this.lenient = parameters.getBoolean(LENIENT_PARSING, false);
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.wrt = this.charsetName == null ? new OutputStreamWriter(new BufferedOutputStream((OutputStream)this.stream, 4096)) : new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)this.stream, 4096), this.charsetName);
    }

    public void close() throws IOException {
        if (this.wrt != null) {
            this.wrt.close();
        }
        super.close();
    }

    public void writeRecord(Record record) throws IOException {
        int numRecFields = record.getNumFields();
        for (int i = 0; i < this.numFields; ++i) {
            int readPos = this.recordPositions[i];
            if (readPos < numRecFields) {
                Value v = record.getField(this.recordPositions[i], this.classes[i]);
                if (v != null) {
                    if (i != 0) {
                        this.wrt.write(this.fieldDelimiter);
                    }
                    this.wrt.write(v.toString());
                    continue;
                }
                if (this.lenient) {
                    if (i == 0) continue;
                    this.wrt.write(this.fieldDelimiter);
                    continue;
                }
                throw new RuntimeException("Cannot serialize record with <null> value at position: " + readPos);
            }
            if (this.lenient) {
                if (i == 0) continue;
                this.wrt.write(this.fieldDelimiter);
                continue;
            }
            throw new RuntimeException("Cannot serialize record with out field at position: " + readPos);
        }
        this.wrt.write(this.recordDelimiter);
    }

    public static ConfigBuilder configureRecordFormat(FileDataSink target) {
        return new ConfigBuilder(target.getParameters());
    }

    public static final class ConfigBuilder
    extends AbstractConfigBuilder<ConfigBuilder> {
        protected ConfigBuilder(Configuration targetConfig) {
            super(targetConfig);
        }
    }

    protected static abstract class AbstractConfigBuilder<T>
    extends FileOutputFormat.AbstractConfigBuilder<T> {
        private static final String NEWLINE_DELIMITER = "\n";

        protected AbstractConfigBuilder(Configuration config) {
            super(config);
        }

        public T recordDelimiter(char delimiter) {
            if (delimiter == '\n') {
                this.config.setString(CsvOutputFormat.RECORD_DELIMITER_PARAMETER, NEWLINE_DELIMITER);
            } else {
                this.config.setString(CsvOutputFormat.RECORD_DELIMITER_PARAMETER, String.valueOf(delimiter));
            }
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T recordDelimiter(String delimiter) {
            this.config.setString(CsvOutputFormat.RECORD_DELIMITER_PARAMETER, delimiter);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T recordDelimiter(String delimiter, String charsetName) {
            this.config.setString(CsvOutputFormat.RECORD_DELIMITER_PARAMETER, delimiter);
            this.config.setString(CsvOutputFormat.RECORD_DELIMITER_ENCODING, charsetName);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T fieldDelimiter(char delimiter) {
            this.config.setString(CsvOutputFormat.FIELD_DELIMITER_PARAMETER, String.valueOf(delimiter));
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T field(Class<? extends Value> type, int recordPosition) {
            int numYet = this.config.getInteger(CsvOutputFormat.NUM_FIELDS_PARAMETER, 0);
            this.config.setClass(CsvOutputFormat.FIELD_TYPE_PARAMETER_PREFIX + numYet, type);
            this.config.setInteger(CsvOutputFormat.RECORD_POSITION_PARAMETER_PREFIX + numYet, recordPosition);
            this.config.setInteger(CsvOutputFormat.NUM_FIELDS_PARAMETER, numYet + 1);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T lenient(boolean lenient) {
            this.config.setBoolean(CsvOutputFormat.LENIENT_PARSING, lenient);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }
    }
}

