/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FirstReducer;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class SortedGrouping<T>
extends Grouping<T> {
    private int[] groupSortKeyPositions;
    private Order[] groupSortOrders;

    public SortedGrouping(DataSet<T> set, Keys<T> keys, int field, Order order) {
        super(set, keys);
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
        }
        if (field >= this.dataSet.getType().getArity()) {
            throw new IllegalArgumentException("Order key out of tuple bounds.");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new int[]{field}, this.dataSet.getType());
        this.groupSortKeyPositions = ek.computeLogicalKeyPositions();
        this.groupSortOrders = new Order[this.groupSortKeyPositions.length];
        Arrays.fill(this.groupSortOrders, order);
    }

    public SortedGrouping(DataSet<T> set, Keys<T> keys, String field, Order order) {
        super(set, keys);
        if (!(this.dataSet.getType() instanceof CompositeType)) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for composite data types (pojo / tuple / case class)");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new String[]{field}, this.dataSet.getType());
        this.groupSortKeyPositions = ek.computeLogicalKeyPositions();
        this.groupSortOrders = new Order[this.groupSortKeyPositions.length];
        Arrays.fill(this.groupSortOrders, order);
    }

    protected int[] getGroupSortKeyPositions() {
        return this.groupSortKeyPositions;
    }

    protected Order[] getGroupSortOrders() {
        return this.groupSortOrders;
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getGroupReduceReturnTypes(reducer, this.getDataSet().getType());
        return new GroupReduceOperator<T, R>(this, resultType, reducer);
    }

    public GroupReduceOperator<T, T> first(int n) {
        if (n < 1) {
            throw new InvalidProgramException("Parameter n of first(n) must be at least 1.");
        }
        return this.reduceGroup(new FirstReducer(n));
    }

    public SortedGrouping<T> sortGroup(int field, Order order) {
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
        }
        if (field >= this.dataSet.getType().getArity()) {
            throw new IllegalArgumentException("Order key out of tuple bounds.");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new int[]{field}, this.dataSet.getType());
        this.addSortGroupInternal(ek, order);
        return this;
    }

    private void addSortGroupInternal(Keys.ExpressionKeys<T> ek, Order order) {
        Preconditions.checkArgument((order != null ? 1 : 0) != 0, (Object)"Order can not be null");
        int[] additionalKeyPositions = ek.computeLogicalKeyPositions();
        int newLength = this.groupSortKeyPositions.length + additionalKeyPositions.length;
        this.groupSortKeyPositions = Arrays.copyOf(this.groupSortKeyPositions, newLength);
        this.groupSortOrders = Arrays.copyOf(this.groupSortOrders, newLength);
        int off = newLength - additionalKeyPositions.length;
        for (int pos = newLength - additionalKeyPositions.length; pos < newLength; ++pos) {
            this.groupSortKeyPositions[pos] = additionalKeyPositions[pos - off];
            this.groupSortOrders[pos] = order;
        }
    }

    public SortedGrouping<T> sortGroup(String field, Order order) {
        if (!(this.dataSet.getType() instanceof CompositeType)) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for composite data types (pojo / tuple / case class)");
        }
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new String[]{field}, this.dataSet.getType());
        this.addSortGroupInternal(ek, order);
        return this;
    }
}

