/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapPartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;

public class MapPartitionOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, MapPartitionOperator<IN, OUT>> {
    protected final MapPartitionFunction<IN, OUT> function;

    public MapPartitionOperator(DataSet<IN> input, TypeInformation<OUT> resultType, MapPartitionFunction<IN, OUT> function) {
        super(input, resultType);
        this.function = function;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    @Override
    protected MapPartitionOperatorBase<IN, OUT, MapPartitionFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        MapPartitionOperatorBase po = new MapPartitionOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setDegreeOfParallelism(this.getParallelism());
        } else {
            po.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return po;
    }
}

