/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.Operator;

public class DataSource<OUT>
extends Operator<OUT, DataSource<OUT>> {
    private final InputFormat<OUT, ?> inputFormat;

    public DataSource(ExecutionEnvironment context, InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> type) {
        super(context, type);
        if (inputFormat == null) {
            throw new IllegalArgumentException("The input format may not be null.");
        }
        this.inputFormat = inputFormat;
        if (inputFormat instanceof NonParallelInput) {
            this.dop = 1;
        }
    }

    public InputFormat<OUT, ?> getInputFormat() {
        return this.inputFormat;
    }

    protected GenericDataSourceBase<OUT, ?> translateToDataFlow() {
        String name;
        String string = name = this.name != null ? this.name : this.inputFormat.toString();
        if (name.length() > 100) {
            name = name.substring(0, 100);
        }
        GenericDataSourceBase source = new GenericDataSourceBase(this.inputFormat, new OperatorInformation(this.getType()), name);
        source.setDegreeOfParallelism(this.dop);
        return source;
    }
}

