/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.InvalidTypesException;
import org.apache.flink.api.java.typeutils.AtomicType;
import org.apache.flink.api.java.typeutils.runtime.WritableComparator;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.types.TypeInformation;
import org.apache.hadoop.io.Writable;

public class WritableTypeInfo<T extends Writable>
extends TypeInformation<T>
implements AtomicType<T> {
    private final Class<T> typeClass;

    public WritableTypeInfo(Class<T> typeClass) {
        if (typeClass == null) {
            throw new NullPointerException();
        }
        if (!Writable.class.isAssignableFrom(typeClass) || typeClass == Writable.class) {
            throw new IllegalArgumentException("WritableTypeInfo can only be used for subclasses of " + Writable.class.getName());
        }
        this.typeClass = typeClass;
    }

    @Override
    public TypeComparator<T> createComparator(boolean sortOrderAscending) {
        if (Comparable.class.isAssignableFrom(this.typeClass)) {
            return new WritableComparator<T>(sortOrderAscending, this.typeClass);
        }
        throw new UnsupportedOperationException("Cannot create Comparator for " + this.typeClass.getCanonicalName() + ". " + "Class does not implement Comparable interface.");
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer() {
        return new WritableSerializer<T>(this.typeClass);
    }

    public String toString() {
        return "WritableType<" + this.typeClass.getName() + ">";
    }

    static final <T extends Writable> TypeInformation<T> getWritableTypeInfo(Class<T> typeClass) {
        if (Writable.class.isAssignableFrom(typeClass) && !typeClass.equals(Writable.class)) {
            return new WritableTypeInfo<T>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Writable.class.getName());
    }
}

