/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class GenericArraySerializer<C>
extends TypeSerializer<C[]> {
    private static final long serialVersionUID = 1L;
    private final Class<C> componentClass;
    private final TypeSerializer<C> componentSerializer;
    private final C[] EMPTY;

    public GenericArraySerializer(Class<C> componentClass, TypeSerializer<C> componentSerializer) {
        if (componentClass == null || componentSerializer == null) {
            throw new NullPointerException();
        }
        this.componentClass = componentClass;
        this.componentSerializer = componentSerializer;
        this.EMPTY = this.create(0);
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return this.componentSerializer.isStateful();
    }

    public C[] createInstance() {
        return this.EMPTY;
    }

    public C[] copy(C[] from, C[] reuse) {
        C[] copy = this.create(from.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.componentSerializer.copy(from[i], this.componentSerializer.createInstance());
        }
        return copy;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(C[] value, DataOutputView target) throws IOException {
        target.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            C val = value[i];
            if (val == null) {
                target.writeBoolean(false);
                continue;
            }
            target.writeBoolean(true);
            this.componentSerializer.serialize(val, target);
        }
    }

    public C[] deserialize(C[] reuse, DataInputView source) throws IOException {
        int len = source.readInt();
        if (reuse.length != len) {
            reuse = this.create(len);
        }
        for (int i = 0; i < len; ++i) {
            boolean isNonNull = source.readBoolean();
            reuse[i] = isNonNull ? this.componentSerializer.deserialize(this.componentSerializer.createInstance(), source) : null;
        }
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            boolean isNonNull = source.readBoolean();
            target.writeBoolean(isNonNull);
            if (!isNonNull) continue;
            this.componentSerializer.copy(source, target);
        }
    }

    private final C[] create(int len) {
        return (Object[])Array.newInstance(this.componentClass, len);
    }

    public int hashCode() {
        return this.componentClass.hashCode() + this.componentSerializer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GenericArraySerializer) {
            GenericArraySerializer other = (GenericArraySerializer)((Object)obj);
            return this.componentClass == other.componentClass && this.componentSerializer.equals(other.componentSerializer);
        }
        return false;
    }
}

