/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.security.InvalidParameterException;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.DeltaIteration;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingCoGroupOperator;
import org.apache.flink.api.java.operators.translation.TupleKeyExtractingMapper;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.TypeInformation;

public class CoGroupOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, CoGroupOperator<I1, I2, OUT>> {
    private final CoGroupFunction<I1, I2, OUT> function;
    private final Keys<I1> keys1;
    private final Keys<I2> keys2;

    protected CoGroupOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType) {
        super(input1, input2, returnType);
        this.function = function;
        if (keys1 == null || keys2 == null) {
            throw new NullPointerException();
        }
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    protected Keys<I1> getKeys1() {
        return this.keys1;
    }

    protected Keys<I2> getKeys2() {
        return this.keys2;
    }

    @Override
    protected CoGroupOperatorBase<?, ?, OUT, ?> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
        String name;
        String string = name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        if (this.keys1 instanceof Keys.SelectorFunctionKeys && this.keys2 instanceof Keys.SelectorFunctionKeys && this.keys1.areCompatibale(this.keys2)) {
            Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
            Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
            PlanUnwrappingCoGroupOperator po = CoGroupOperator.translateSelectorFunctionCoGroup(selectorKeys1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        if (this.keys1 instanceof Keys.FieldPositionKeys && this.keys2 instanceof Keys.FieldPositionKeys || this.keys1 instanceof Keys.ExpressionKeys && this.keys2 instanceof Keys.ExpressionKeys) {
            if (!this.keys1.areCompatibale(this.keys2)) {
                throw new InvalidProgramException("The types of the key fields do not match.");
            }
            int[] logicalKeyPositions1 = this.keys1.computeLogicalKeyPositions();
            int[] logicalKeyPositions2 = this.keys2.computeLogicalKeyPositions();
            CoGroupOperatorBase po = new CoGroupOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), logicalKeyPositions1, logicalKeyPositions2, name);
            po.setFirstInput(input1);
            po.setSecondInput(input2);
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        if (this.keys1 instanceof Keys.FieldPositionKeys && this.keys2 instanceof Keys.SelectorFunctionKeys && this.keys1.areCompatibale(this.keys2)) {
            int[] logicalKeyPositions1 = this.keys1.computeLogicalKeyPositions();
            Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
            PlanUnwrappingCoGroupOperator po = CoGroupOperator.translateSelectorFunctionCoGroupRight(logicalKeyPositions1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        if (this.keys1 instanceof Keys.SelectorFunctionKeys && this.keys2 instanceof Keys.FieldPositionKeys && this.keys1.areCompatibale(this.keys2)) {
            Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
            int[] logicalKeyPositions2 = this.keys2.computeLogicalKeyPositions();
            PlanUnwrappingCoGroupOperator po = CoGroupOperator.translateSelectorFunctionCoGroupLeft(selectorKeys1, logicalKeyPositions2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized or incompatible key types.");
    }

    private static <I1, I2, K, OUT> PlanUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroup(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
        Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
        TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
        TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
        KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
        KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
        MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
        MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
        PlanUnwrappingCoGroupOperator cogroup = new PlanUnwrappingCoGroupOperator(function, keys1, keys2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
        cogroup.setFirstInput((Operator)keyMapper1);
        cogroup.setSecondInput((Operator)keyMapper2);
        keyMapper1.setInput(input1);
        keyMapper2.setInput(input2);
        keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
        keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
        return cogroup;
    }

    private static <I1, I2, K, OUT> PlanUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroupRight(int[] logicalKeyPositions1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        if (!inputType1.isTupleType()) {
            throw new InvalidParameterException("Should not happen.");
        }
        Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
        TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys2.getKeyType(), inputType1);
        TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
        TupleKeyExtractingMapper extractor1 = new TupleKeyExtractingMapper(logicalKeyPositions1[0]);
        KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
        MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
        MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
        PlanUnwrappingCoGroupOperator cogroup = new PlanUnwrappingCoGroupOperator(function, logicalKeyPositions1, keys2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
        cogroup.setFirstInput((Operator)keyMapper1);
        cogroup.setSecondInput((Operator)keyMapper2);
        keyMapper1.setInput(input1);
        keyMapper2.setInput(input2);
        keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
        keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
        return cogroup;
    }

    private static <I1, I2, K, OUT> PlanUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroupLeft(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, int[] logicalKeyPositions2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        if (!inputType2.isTupleType()) {
            throw new InvalidParameterException("Should not happen.");
        }
        Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
        TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
        TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys1.getKeyType(), inputType2);
        KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
        TupleKeyExtractingMapper extractor2 = new TupleKeyExtractingMapper(logicalKeyPositions2[0]);
        MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
        MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
        PlanUnwrappingCoGroupOperator cogroup = new PlanUnwrappingCoGroupOperator(function, keys1, logicalKeyPositions2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
        cogroup.setFirstInput((Operator)keyMapper1);
        cogroup.setSecondInput((Operator)keyMapper2);
        keyMapper1.setInput(input1);
        keyMapper2.setInput(input2);
        keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
        keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
        return cogroup;
    }

    public static final class CoGroupOperatorSets<I1, I2> {
        private final DataSet<I1> input1;
        private final DataSet<I2> input2;

        public CoGroupOperatorSets(DataSet<I1> input1, DataSet<I2> input2) {
            if (input1 == null || input2 == null) {
                throw new NullPointerException();
            }
            this.input1 = input1;
            this.input2 = input2;
        }

        public CoGroupOperatorSetsPredicate where(int ... fields) {
            return new CoGroupOperatorSetsPredicate(new Keys.FieldPositionKeys<I1>(fields, this.input1.getType()));
        }

        public <K> CoGroupOperatorSetsPredicate where(KeySelector<I1, K> keyExtractor) {
            return new CoGroupOperatorSetsPredicate(new Keys.SelectorFunctionKeys<I1, K>(keyExtractor, this.input1.getType()));
        }

        public final class CoGroupOperatorSetsPredicate {
            private final Keys<I1> keys1;

            private CoGroupOperatorSetsPredicate(Keys<I1> keys1) {
                if (keys1 == null) {
                    throw new NullPointerException();
                }
                if (keys1.isEmpty()) {
                    throw new InvalidProgramException("The co-group keys must not be empty.");
                }
                this.keys1 = keys1;
            }

            public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction equalTo(int ... fields) {
                return this.createCoGroupOperator(new Keys.FieldPositionKeys(fields, CoGroupOperatorSets.this.input2.getType()));
            }

            public <K> org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction equalTo(KeySelector<I2, K> keyExtractor) {
                return this.createCoGroupOperator(new Keys.SelectorFunctionKeys(keyExtractor, CoGroupOperatorSets.this.input2.getType()));
            }

            private org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction createCoGroupOperator(Keys<I2> keys2) {
                int[] positions;
                if (keys2 == null) {
                    throw new NullPointerException();
                }
                if (keys2.isEmpty()) {
                    throw new InvalidProgramException("The co-group keys must not be empty.");
                }
                if (!this.keys1.areCompatibale(keys2)) {
                    throw new InvalidProgramException("The pair of co-group keys are not compatible with each other.");
                }
                if (CoGroupOperatorSets.this.input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
                    if (this.keys1 instanceof Keys.FieldPositionKeys) {
                        positions = ((Keys.FieldPositionKeys)this.keys1).computeLogicalKeyPositions();
                        ((DeltaIteration.SolutionSetPlaceHolder)CoGroupOperatorSets.this.input1).checkJoinKeyFields(positions);
                    } else {
                        throw new InvalidProgramException("Currently, the solution set may only be CoGrouped with using tuple field positions.");
                    }
                }
                if (CoGroupOperatorSets.this.input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
                    if (keys2 instanceof Keys.FieldPositionKeys) {
                        positions = ((Keys.FieldPositionKeys)keys2).computeLogicalKeyPositions();
                        ((DeltaIteration.SolutionSetPlaceHolder)CoGroupOperatorSets.this.input2).checkJoinKeyFields(positions);
                    } else {
                        throw new InvalidProgramException("Currently, the solution set may only be CoGrouped with using tuple field positions.");
                    }
                }
                return new CoGroupOperatorWithoutFunction(keys2);
            }

            public final class CoGroupOperatorWithoutFunction {
                private final Keys<I2> keys2;

                private CoGroupOperatorWithoutFunction(Keys<I2> keys2) {
                    if (keys2 == null) {
                        throw new NullPointerException();
                    }
                    if (keys2.isEmpty()) {
                        throw new InvalidProgramException("The co-group keys must not be empty.");
                    }
                    this.keys2 = keys2;
                }

                public <R> CoGroupOperator<I1, I2, R> with(CoGroupFunction<I1, I2, R> function) {
                    if (function == null) {
                        throw new NullPointerException("CoGroup function must not be null.");
                    }
                    if (FunctionUtils.isLambdaFunction(function)) {
                        throw new UnsupportedLambdaExpressionException();
                    }
                    TypeInformation<R> returnType = TypeExtractor.getCoGroupReturnTypes(function, CoGroupOperatorSets.this.input1.getType(), CoGroupOperatorSets.this.input2.getType());
                    return new CoGroupOperator(CoGroupOperatorSets.this.input1, CoGroupOperatorSets.this.input2, CoGroupOperatorSetsPredicate.this.keys1, this.keys2, function, returnType);
                }
            }
        }
    }
}

