/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.DataInput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.Writable;

public class WritableComparator<T extends Writable & Comparable<T>>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private Class<T> type;
    private final boolean ascendingComparison;
    private transient T reference;
    private transient T tempReference;
    private transient Kryo kryo;

    public WritableComparator(boolean ascending, Class<T> type) {
        this.type = type;
        this.ascendingComparison = ascending;
    }

    public int hash(T record) {
        return record.hashCode();
    }

    public void setReference(T toCompare) {
        this.checkKryoInitialized();
        this.reference = (Writable)this.kryo.copy(toCompare);
    }

    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        T otherRef = ((WritableComparator)referencedComparator).reference;
        int comp = ((Comparable)otherRef).compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(T first, T second) {
        int comp = ((Comparable)first).compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.ensureReferenceInstantiated();
        this.ensureTempReferenceInstantiated();
        this.reference.readFields((DataInput)firstSource);
        this.tempReference.readFields((DataInput)secondSource);
        int comp = ((Comparable)this.reference).compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(this.type);
    }

    public int getNormalizeKeyLen() {
        this.ensureReferenceInstantiated();
        NormalizableKey key = (NormalizableKey)this.reference;
        return key.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)record;
        key.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<T> duplicate() {
        return new WritableComparator<T>(this.ascendingComparison, this.type);
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    private final void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    private final void ensureReferenceInstantiated() {
        if (this.reference == null) {
            this.reference = (Writable)InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }

    private final void ensureTempReferenceInstantiated() {
        if (this.tempReference == null) {
            this.tempReference = (Writable)InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }
}

