/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class PojoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> clazz;
    private final TypeSerializer<Object>[] fieldSerializers;
    private transient Field[] fields;
    private final int numFields;
    private final boolean stateful;

    public PojoSerializer(Class<T> clazz, TypeSerializer<?>[] fieldSerializers, Field[] fields) {
        this.clazz = clazz;
        this.fieldSerializers = fieldSerializers;
        this.fields = fields;
        this.numFields = fieldSerializers.length;
        for (int i = 0; i < this.numFields; ++i) {
            this.fields[i].setAccessible(true);
        }
        boolean stateful = false;
        for (TypeSerializer<?> ser : fieldSerializers) {
            if (!ser.isStateful()) continue;
            stateful = true;
            break;
        }
        this.stateful = stateful;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.fields.length);
        for (Field field : this.fields) {
            out.writeObject(field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numKeyFields = in.readInt();
        this.fields = new Field[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            String fieldName = in.readUTF();
            this.fields[i] = null;
            for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    this.fields[i] = clazz.getDeclaredField(fieldName);
                    this.fields[i].setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            if (this.fields[i] != null) continue;
            throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup. (" + fieldName + ")");
        }
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public T createInstance() {
        try {
            T t = this.clazz.newInstance();
            for (int i = 0; i < this.numFields; ++i) {
                this.fields[i].set(t, this.fieldSerializers[i].createInstance());
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate class.", e);
        }
    }

    public T copy(T from, T reuse) {
        try {
            for (int i = 0; i < this.numFields; ++i) {
                Object copy = this.fieldSerializers[i].copy(this.fields[i].get(from), this.fields[i].get(reuse));
                this.fields[i].set(reuse, copy);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
        }
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        try {
            for (int i = 0; i < this.numFields; ++i) {
                Object o = this.fields[i].get(value);
                this.fieldSerializers[i].serialize(o, target);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        try {
            for (int i = 0; i < this.numFields; ++i) {
                Object field = this.fieldSerializers[i].deserialize(this.fields[i].get(reuse), source);
                this.fields[i].set(reuse, field);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
        }
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        for (int i = 0; i < this.numFields; ++i) {
            this.fieldSerializers[i].copy(source, target);
        }
    }

    public int hashCode() {
        int hashCode = this.numFields * 47;
        for (TypeSerializer<Object> ser : this.fieldSerializers) {
            hashCode = hashCode << 7 | hashCode >>> -7;
            hashCode += ser.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PojoSerializer) {
            PojoSerializer otherTS = (PojoSerializer)((Object)obj);
            return otherTS.clazz == this.clazz && Arrays.deepEquals(this.fieldSerializers, otherTS.fieldSerializers);
        }
        return false;
    }
}

