/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;

public class PojoPairComparator<T1, T2>
extends TypePairComparator<T1, T2>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] keyPositions1;
    private final int[] keyPositions2;
    private transient Field[] keyFields1;
    private transient Field[] keyFields2;
    private final TypeComparator<Object>[] comparators1;
    private final TypeComparator<Object>[] comparators2;

    public PojoPairComparator(int[] keyPositions1, Field[] keyFields1, int[] keyPositions2, Field[] keyFields2, TypeComparator<Object>[] comparators1, TypeComparator<Object>[] comparators2) {
        if (keyPositions1.length != keyPositions2.length || keyPositions1.length != comparators1.length || keyPositions2.length != comparators2.length) {
            throw new IllegalArgumentException("Number of key fields and comparators differ.");
        }
        int numKeys = keyPositions1.length;
        this.keyPositions1 = keyPositions1;
        this.keyPositions2 = keyPositions2;
        this.keyFields1 = keyFields1;
        this.keyFields2 = keyFields2;
        this.comparators1 = new TypeComparator[numKeys];
        this.comparators2 = new TypeComparator[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            this.comparators1[i] = comparators1[i].duplicate();
            this.comparators2[i] = comparators2[i].duplicate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.keyFields1.length);
        for (Field field : this.keyFields1) {
            out.writeObject(field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
        out.writeInt(this.keyFields2.length);
        for (Field field : this.keyFields2) {
            out.writeObject(field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String fieldName;
        Class clazz;
        int i;
        in.defaultReadObject();
        int numKeyFields = in.readInt();
        this.keyFields1 = new Field[numKeyFields];
        for (i = 0; i < numKeyFields; ++i) {
            clazz = (Class)in.readObject();
            fieldName = in.readUTF();
            try {
                this.keyFields1[i] = clazz.getField(fieldName);
                this.keyFields1[i].setAccessible(true);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup.");
            }
        }
        numKeyFields = in.readInt();
        this.keyFields2 = new Field[numKeyFields];
        for (i = 0; i < numKeyFields; ++i) {
            clazz = (Class)in.readObject();
            fieldName = in.readUTF();
            try {
                this.keyFields2[i] = clazz.getField(fieldName);
                this.keyFields2[i].setAccessible(true);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup.");
            }
        }
    }

    public void setReference(T1 reference) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            try {
                this.comparators1[i].setReference(this.keyFields1[i].get(reference));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
            }
        }
    }

    public boolean equalToReference(T2 candidate) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            try {
                if (this.comparators1[i].equalToReference(this.keyFields2[i].get(candidate))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup.");
            }
        }
        return true;
    }

    public int compareToReference(T2 candidate) {
        for (int i = 0; i < this.comparators1.length; ++i) {
            try {
                this.comparators2[i].setReference(this.keyFields2[i].get(candidate));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup.");
            }
            int res = this.comparators1[i].compareToReference(this.comparators2[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

