/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;

public class SortedGrouping<T>
extends Grouping<T> {
    private int[] groupSortKeyPositions;
    private Order[] groupSortOrders;

    public SortedGrouping(DataSet<T> set, Keys<T> keys, int field, Order order) {
        super(set, keys);
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
        }
        if (field >= this.dataSet.getType().getArity()) {
            throw new IllegalArgumentException("Order key out of tuple bounds.");
        }
        this.groupSortKeyPositions = new int[]{field};
        this.groupSortOrders = new Order[]{order};
    }

    protected int[] getGroupSortKeyPositions() {
        return this.groupSortKeyPositions;
    }

    protected Order[] getGroupSortOrders() {
        return this.groupSortOrders;
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        if (FunctionUtils.isLambdaFunction(reducer)) {
            throw new UnsupportedLambdaExpressionException();
        }
        return new GroupReduceOperator<T, R>(this, reducer);
    }

    public SortedGrouping<T> sortGroup(int field, Order order) {
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
        }
        if (field >= this.dataSet.getType().getArity()) {
            throw new IllegalArgumentException("Order key out of tuple bounds.");
        }
        int newLength = this.groupSortKeyPositions.length + 1;
        this.groupSortKeyPositions = Arrays.copyOf(this.groupSortKeyPositions, newLength);
        this.groupSortOrders = Arrays.copyOf(this.groupSortOrders, newLength);
        int pos = newLength - 1;
        this.groupSortKeyPositions[pos] = field;
        this.groupSortOrders[pos] = order;
        return this;
    }
}

