/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.security.InvalidParameterException;
import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.DeltaIteration;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.RichFlatJoinFunction;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingJoinOperator;
import org.apache.flink.api.java.operators.translation.TupleKeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.TypeInformation;
import org.apache.flink.util.Collector;

public abstract class JoinOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, JoinOperator<I1, I2, OUT>> {
    private final Keys<I1> keys1;
    private final Keys<I2> keys2;
    private JoinHint joinHint;

    protected JoinOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, TypeInformation<OUT> returnType, JoinHint hint) {
        super(input1, input2, returnType);
        if (keys1 == null || keys2 == null) {
            throw new NullPointerException();
        }
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.joinHint = hint;
    }

    protected Keys<I1> getKeys1() {
        return this.keys1;
    }

    protected Keys<I2> getKeys2() {
        return this.keys2;
    }

    protected JoinHint getJoinHint() {
        return this.joinHint;
    }

    public static final class JoinProjection<I1, I2> {
        private final DataSet<I1> ds1;
        private final DataSet<I2> ds2;
        private final Keys<I1> keys1;
        private final Keys<I2> keys2;
        private final JoinHint hint;
        private int[] fieldIndexes;
        private boolean[] isFieldInFirst;
        private final int numFieldsDs1;
        private final int numFieldsDs2;

        public JoinProjection(DataSet<I1> ds1, DataSet<I2> ds2, Keys<I1> keys1, Keys<I2> keys2, JoinHint hint, int[] firstFieldIndexes, int[] secondFieldIndexes) {
            boolean isTuple;
            boolean firstInput;
            boolean isSecondTuple;
            boolean isFirstTuple;
            this.ds1 = ds1;
            this.ds2 = ds2;
            this.keys1 = keys1;
            this.keys2 = keys2;
            this.hint = hint;
            if (ds1.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs1 = ((TupleTypeInfo)ds1.getType()).getArity();
                isFirstTuple = true;
            } else {
                this.numFieldsDs1 = 1;
                isFirstTuple = false;
            }
            if (ds2.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs2 = ((TupleTypeInfo)ds2.getType()).getArity();
                isSecondTuple = true;
            } else {
                this.numFieldsDs2 = 1;
                isSecondTuple = false;
            }
            if (firstFieldIndexes != null && secondFieldIndexes == null) {
                firstInput = true;
                isTuple = isFirstTuple;
                this.fieldIndexes = firstFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else if (firstFieldIndexes == null && secondFieldIndexes != null) {
                firstInput = false;
                isTuple = isSecondTuple;
                this.fieldIndexes = secondFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else {
                if (firstFieldIndexes == null && secondFieldIndexes == null) {
                    throw new IllegalArgumentException("You must provide at least one field index array.");
                }
                throw new IllegalArgumentException("You must provide at most one field index array.");
            }
            if (!isTuple && this.fieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() (or projectSecond()) without arguments to include it.");
            }
            if (this.fieldIndexes.length > 22) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields.");
            }
            if (isTuple) {
                this.isFieldInFirst = new boolean[this.fieldIndexes.length];
                int maxFieldIndex = firstInput ? this.numFieldsDs1 : this.numFieldsDs2;
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    if (this.fieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[i] = firstInput;
                }
            } else {
                this.isFieldInFirst = new boolean[]{firstInput};
                this.fieldIndexes = new int[]{-1};
            }
        }

        public JoinProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            boolean isFirstTuple = this.ds1.getType() instanceof TupleTypeInfo && firstFieldIndexes.length > 0;
            if (!isFirstTuple && firstFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() without arguments to include it.");
            }
            if (firstFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isFirstTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + firstFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + firstFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs1;
                for (int i = 0; i < firstFieldIndexes.length; ++i) {
                    if (firstFieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[offset + i] = true;
                    this.fieldIndexes[offset + i] = firstFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = true;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public JoinProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            boolean isSecondTuple = this.ds2.getType() instanceof TupleTypeInfo && secondFieldIndexes.length > 0;
            if (!isSecondTuple && secondFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectSecond() without arguments to include it.");
            }
            if (secondFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isSecondTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + secondFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + secondFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs2;
                for (int i = 0; i < secondFieldIndexes.length; ++i) {
                    if (secondFieldIndexes[i] > maxFieldIndex - 1) {
                        throw new IndexOutOfBoundsException("Provided field index is out of bounds of input tuple.");
                    }
                    this.isFieldInFirst[offset + i] = false;
                    this.fieldIndexes[offset + i] = secondFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = false;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public <T0> ProjectJoin<I1, I2, Tuple1<T0>> types(Class<T0> type0) {
            Class[] types = new Class[]{type0};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1> ProjectJoin<I1, I2, Tuple2<T0, T1>> types(Class<T0> type0, Class<T1> type1) {
            Class[] types = new Class[]{type0, type1};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2> ProjectJoin<I1, I2, Tuple3<T0, T1, T2>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2) {
            Class[] types = new Class[]{type0, type1, type2};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3> ProjectJoin<I1, I2, Tuple4<T0, T1, T2, T3>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3) {
            Class[] types = new Class[]{type0, type1, type2, type3};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4> ProjectJoin<I1, I2, Tuple5<T0, T1, T2, T3, T4>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5> ProjectJoin<I1, I2, Tuple6<T0, T1, T2, T3, T4, T5>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6> ProjectJoin<I1, I2, Tuple7<T0, T1, T2, T3, T4, T5, T6>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7> ProjectJoin<I1, I2, Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8> ProjectJoin<I1, I2, Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ProjectJoin<I1, I2, Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ProjectJoin<I1, I2, Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ProjectJoin<I1, I2, Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ProjectJoin<I1, I2, Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ProjectJoin<I1, I2, Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ProjectJoin<I1, I2, Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ProjectJoin<I1, I2, Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ProjectJoin<I1, I2, Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ProjectJoin<I1, I2, Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ProjectJoin<I1, I2, Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ProjectJoin<I1, I2, Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ProjectJoin<I1, I2, Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ProjectJoin<I1, I2, Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ProjectJoin<I1, I2, Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> ProjectJoin<I1, I2, Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> ProjectJoin<I1, I2, Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> types(Class<T0> type0, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6, Class<T7> type7, Class<T8> type8, Class<T9> type9, Class<T10> type10, Class<T11> type11, Class<T12> type12, Class<T13> type13, Class<T14> type14, Class<T15> type15, Class<T16> type16, Class<T17> type17, Class<T18> type18, Class<T19> type19, Class<T20> type20, Class<T21> type21, Class<T22> type22, Class<T23> type23, Class<T24> type24) {
            Class[] types = new Class[]{type0, type1, type2, type3, type4, type5, type6, type7, type8, type9, type10, type11, type12, type13, type14, type15, type16, type17, type18, type19, type20, type21, type22, type23, type24};
            if (types.length != this.fieldIndexes.length) {
                throw new IllegalArgumentException("Numbers of projected fields and types do not match.");
            }
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes, types);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType);
        }

        private TypeInformation<?>[] extractFieldTypes(int[] fields, Class<?>[] givenTypes) {
            TypeInformation[] fieldTypes = new TypeInformation[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object typeInfo = this.isFieldInFirst[i] ? (fields[i] >= 0 ? ((TupleTypeInfo)this.ds1.getType()).getTypeAt(fields[i]) : this.ds1.getType()) : (fields[i] >= 0 ? ((TupleTypeInfo)this.ds2.getType()).getTypeAt(fields[i]) : this.ds2.getType());
                if (typeInfo.getTypeClass() != givenTypes[i]) {
                    throw new IllegalArgumentException("Given types do not match types of input data set.");
                }
                fieldTypes[i] = typeInfo;
            }
            return fieldTypes;
        }
    }

    public static final class RightSemiFlatJoinFunction<T1, T2>
    extends RichFlatJoinFunction<T1, T2, T2> {
        private static final long serialVersionUID = 1L;

        @Override
        public void join(T1 left, T2 right, Collector<T2> out) {
            out.collect(right);
        }
    }

    public static final class LeftSemiFlatJoinFunction<T1, T2>
    extends RichFlatJoinFunction<T1, T2, T1> {
        private static final long serialVersionUID = 1L;

        @Override
        public void join(T1 left, T2 right, Collector<T1> out) {
            out.collect(left);
        }
    }

    public static final class ProjectFlatJoinFunction<T1, T2, R extends Tuple>
    extends RichFlatJoinFunction<T1, T2, R> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private final boolean[] isFromFirst;
        private final R outTuple;

        private ProjectFlatJoinFunction(int[] fields, boolean[] isFromFirst, R outTupleInstance) {
            if (fields.length != isFromFirst.length) {
                throw new IllegalArgumentException("Fields and isFromFirst arrays must have same length!");
            }
            this.fields = fields;
            this.isFromFirst = isFromFirst;
            this.outTuple = outTupleInstance;
        }

        protected int[] getFields() {
            return this.fields;
        }

        protected boolean[] getIsFromFirst() {
            return this.isFromFirst;
        }

        @Override
        public void join(T1 in1, T2 in2, Collector<R> out) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.isFromFirst[i]) {
                    if (this.fields[i] >= 0) {
                        ((Tuple)this.outTuple).setField(((Tuple)in1).getField(this.fields[i]), i);
                        continue;
                    }
                    ((Tuple)this.outTuple).setField(in1, i);
                    continue;
                }
                if (this.fields[i] >= 0) {
                    ((Tuple)this.outTuple).setField(((Tuple)in2).getField(this.fields[i]), i);
                    continue;
                }
                ((Tuple)this.outTuple).setField(in2, i);
            }
            out.collect(this.outTuple);
        }

        /* synthetic */ ProjectFlatJoinFunction(int[] x0, boolean[] x1, Tuple x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static final class DefaultFlatJoinFunction<T1, T2>
    extends RichFlatJoinFunction<T1, T2, Tuple2<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<T1, T2> outTuple = new Tuple2();

        @Override
        public void join(T1 first, T2 second, Collector<Tuple2<T1, T2>> out) throws Exception {
            this.outTuple.f0 = first;
            this.outTuple.f1 = second;
            out.collect(this.outTuple);
        }
    }

    public static final class JoinOperatorSets<I1, I2> {
        private final DataSet<I1> input1;
        private final DataSet<I2> input2;
        private final JoinHint joinHint;

        public JoinOperatorSets(DataSet<I1> input1, DataSet<I2> input2) {
            this(input1, input2, JoinHint.OPTIMIZER_CHOOSES);
        }

        public JoinOperatorSets(DataSet<I1> input1, DataSet<I2> input2, JoinHint hint) {
            if (input1 == null || input2 == null) {
                throw new NullPointerException();
            }
            this.input1 = input1;
            this.input2 = input2;
            this.joinHint = hint;
        }

        public JoinOperatorSetsPredicate where(int ... fields) {
            return new JoinOperatorSetsPredicate(new Keys.FieldPositionKeys<I1>(fields, this.input1.getType()));
        }

        public <K extends Comparable<K>> JoinOperatorSetsPredicate where(KeySelector<I1, K> keySelector) {
            return new JoinOperatorSetsPredicate(new Keys.SelectorFunctionKeys<I1, K>(keySelector, this.input1.getType()));
        }

        public class JoinOperatorSetsPredicate {
            private final Keys<I1> keys1;

            private JoinOperatorSetsPredicate(Keys<I1> keys1) {
                if (keys1 == null) {
                    throw new NullPointerException();
                }
                if (keys1.isEmpty()) {
                    throw new InvalidProgramException("The join keys must not be empty.");
                }
                this.keys1 = keys1;
            }

            public DefaultJoin<I1, I2> equalTo(int ... fields) {
                return this.createJoinOperator(new Keys.FieldPositionKeys(fields, JoinOperatorSets.this.input2.getType()));
            }

            public <K> DefaultJoin<I1, I2> equalTo(KeySelector<I2, K> keySelector) {
                return this.createJoinOperator(new Keys.SelectorFunctionKeys(keySelector, JoinOperatorSets.this.input2.getType()));
            }

            protected DefaultJoin<I1, I2> createJoinOperator(Keys<I2> keys2) {
                int[] positions;
                if (keys2 == null) {
                    throw new NullPointerException("The join keys may not be null.");
                }
                if (keys2.isEmpty()) {
                    throw new InvalidProgramException("The join keys may not be empty.");
                }
                if (!this.keys1.areCompatibale(keys2)) {
                    throw new InvalidProgramException("The pair of join keys are not compatible with each other.");
                }
                if (JoinOperatorSets.this.input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
                    if (this.keys1 instanceof Keys.FieldPositionKeys) {
                        positions = ((Keys.FieldPositionKeys)this.keys1).computeLogicalKeyPositions();
                        ((DeltaIteration.SolutionSetPlaceHolder)JoinOperatorSets.this.input1).checkJoinKeyFields(positions);
                    } else {
                        throw new InvalidProgramException("Currently, the solution set may only be joined with using tuple field positions.");
                    }
                }
                if (JoinOperatorSets.this.input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
                    if (keys2 instanceof Keys.FieldPositionKeys) {
                        positions = ((Keys.FieldPositionKeys)keys2).computeLogicalKeyPositions();
                        ((DeltaIteration.SolutionSetPlaceHolder)JoinOperatorSets.this.input2).checkJoinKeyFields(positions);
                    } else {
                        throw new InvalidProgramException("Currently, the solution set may only be joined with using tuple field positions.");
                    }
                }
                return new DefaultJoin(JoinOperatorSets.this.input1, JoinOperatorSets.this.input2, this.keys1, keys2, JoinOperatorSets.this.joinHint);
            }
        }
    }

    public static final class ProjectJoin<I1, I2, OUT extends Tuple>
    extends EquiJoin<I1, I2, OUT> {
        protected ProjectJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, JoinHint hint, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType) {
            super(input1, input2, keys1, keys2, new ProjectFlatJoinFunction(fields, isFromFirst, (Tuple)returnType.createSerializer().createInstance(), null), returnType, hint);
        }

        @Override
        public JoinOperator<I1, I2, OUT> withConstantSetFirst(String ... constantSetFirst) {
            throw new InvalidProgramException("The semantic properties (constant fields and forwarded fields) are automatically calculated.");
        }

        @Override
        public JoinOperator<I1, I2, OUT> withConstantSetSecond(String ... constantSetSecond) {
            throw new InvalidProgramException("The semantic properties (constant fields and forwarded fields) are automatically calculated.");
        }
    }

    public static final class DefaultJoin<I1, I2>
    extends EquiJoin<I1, I2, Tuple2<I1, I2>> {
        protected DefaultJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, JoinHint hint) {
            super(input1, input2, keys1, keys2, new DefaultFlatJoinFunction(), new TupleTypeInfo(input1.getType(), input2.getType()), hint);
        }

        public <R> EquiJoin<I1, I2, R> with(FlatJoinFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Join function must not be null.");
            }
            if (FunctionUtils.isLambdaFunction(function)) {
                throw new UnsupportedLambdaExpressionException();
            }
            TypeInformation<R> returnType = TypeExtractor.getJoinReturnTypes(function, this.getInput1Type(), this.getInput2Type());
            return new EquiJoin(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), function, returnType, this.getJoinHint());
        }

        public <R> EquiJoin<I1, I2, R> with(JoinFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Join function must not be null.");
            }
            if (FunctionUtils.isLambdaFunction(function)) {
                throw new UnsupportedLambdaExpressionException();
            }
            WrappingFlatJoinFunction generatedFunction = new WrappingFlatJoinFunction(function);
            TypeInformation<R> returnType = TypeExtractor.getJoinReturnTypes(function, this.getInput1Type(), this.getInput2Type());
            return new EquiJoin(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), generatedFunction, function, returnType, this.getJoinHint());
        }

        public JoinProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            return new JoinProjection(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), this.getJoinHint(), firstFieldIndexes, null);
        }

        public JoinProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            return new JoinProjection(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), this.getJoinHint(), null, secondFieldIndexes);
        }

        private static class WrappingFlatJoinFunction<IN1, IN2, OUT>
        extends WrappingFunction<JoinFunction<IN1, IN2, OUT>>
        implements FlatJoinFunction<IN1, IN2, OUT> {
            private static final long serialVersionUID = 1L;

            private WrappingFlatJoinFunction(JoinFunction<IN1, IN2, OUT> wrappedFunction) {
                super(wrappedFunction);
            }

            public void join(IN1 left, IN2 right, Collector<OUT> out) throws Exception {
                out.collect(((JoinFunction)this.wrappedFunction).join(left, right));
            }
        }
    }

    public static class EquiJoin<I1, I2, OUT>
    extends JoinOperator<I1, I2, OUT> {
        private final FlatJoinFunction<I1, I2, OUT> function;
        private boolean preserve1;
        private boolean preserve2;

        protected EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinHint hint) {
            super(input1, input2, keys1, keys2, returnType, hint);
            if (function == null) {
                throw new NullPointerException();
            }
            this.function = function;
            if (!(function instanceof ProjectFlatJoinFunction)) {
                this.extractSemanticAnnotationsFromUdf(function.getClass());
            } else {
                this.generateProjectionProperties((ProjectFlatJoinFunction)function);
            }
        }

        protected EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> generatedFunction, JoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinHint hint) {
            super(input1, input2, keys1, keys2, returnType, hint);
            if (function == null) {
                throw new NullPointerException();
            }
            this.function = generatedFunction;
            if (!(generatedFunction instanceof ProjectFlatJoinFunction)) {
                this.extractSemanticAnnotationsFromUdf(function.getClass());
            } else {
                this.generateProjectionProperties((ProjectFlatJoinFunction)generatedFunction);
            }
        }

        public void generateProjectionProperties(ProjectFlatJoinFunction<?, ?, ?> pjf) {
            DualInputSemanticProperties props = SemanticPropUtil.createProjectionPropertiesDual(pjf.getFields(), pjf.getIsFromFirst());
            this.setSemanticProperties(props);
        }

        @Override
        protected JoinOperatorBase<?, ?, OUT, ?> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
            String name;
            String string = name = this.getName() != null ? this.getName() : this.function.getClass().getName();
            if (((JoinOperator)this).keys1 instanceof Keys.SelectorFunctionKeys && ((JoinOperator)this).keys2 instanceof Keys.SelectorFunctionKeys && ((JoinOperator)this).keys1.areCompatibale(((JoinOperator)this).keys2)) {
                Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)((JoinOperator)this).keys1;
                Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)((JoinOperator)this).keys2;
                PlanUnwrappingJoinOperator po = EquiJoin.translateSelectorFunctionJoin(selectorKeys1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
                po.setDegreeOfParallelism(this.getParallelism());
                return po;
            }
            if (((JoinOperator)this).keys1 instanceof Keys.FieldPositionKeys && ((JoinOperator)this).keys2 instanceof Keys.FieldPositionKeys || ((JoinOperator)this).keys1 instanceof Keys.ExpressionKeys && ((JoinOperator)this).keys2 instanceof Keys.ExpressionKeys) {
                if (!((JoinOperator)this).keys1.areCompatibale(((JoinOperator)this).keys2)) {
                    throw new InvalidProgramException("The types of the key fields do not match.");
                }
                int[] logicalKeyPositions1 = ((JoinOperator)this).keys1.computeLogicalKeyPositions();
                int[] logicalKeyPositions2 = ((JoinOperator)this).keys2.computeLogicalKeyPositions();
                JoinOperatorBase po = new JoinOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), logicalKeyPositions1, logicalKeyPositions2, name);
                po.setFirstInput(input1);
                po.setSecondInput(input2);
                po.setDegreeOfParallelism(this.getParallelism());
                return po;
            }
            if (((JoinOperator)this).keys1 instanceof Keys.FieldPositionKeys && ((JoinOperator)this).keys2 instanceof Keys.SelectorFunctionKeys && ((JoinOperator)this).keys1.areCompatibale(((JoinOperator)this).keys2)) {
                int[] logicalKeyPositions1 = ((JoinOperator)this).keys1.computeLogicalKeyPositions();
                Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)((JoinOperator)this).keys2;
                PlanUnwrappingJoinOperator po = EquiJoin.translateSelectorFunctionJoinRight(logicalKeyPositions1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
                po.setDegreeOfParallelism(this.getParallelism());
                return po;
            }
            if (((JoinOperator)this).keys1 instanceof Keys.SelectorFunctionKeys && ((JoinOperator)this).keys2 instanceof Keys.FieldPositionKeys && ((JoinOperator)this).keys1.areCompatibale(((JoinOperator)this).keys2)) {
                Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)((JoinOperator)this).keys1;
                int[] logicalKeyPositions2 = ((JoinOperator)this).keys2.computeLogicalKeyPositions();
                PlanUnwrappingJoinOperator po = EquiJoin.translateSelectorFunctionJoinLeft(selectorKeys1, logicalKeyPositions2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
                po.setDegreeOfParallelism(this.getParallelism());
                return po;
            }
            throw new UnsupportedOperationException("Unrecognized or incompatible key types.");
        }

        private static <I1, I2, K, OUT> PlanUnwrappingJoinOperator<I1, I2, OUT, K> translateSelectorFunctionJoin(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
            Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
            Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
            TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
            TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
            KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
            KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
            MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
            MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
            PlanUnwrappingJoinOperator join = new PlanUnwrappingJoinOperator(function, keys1, keys2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
            join.setFirstInput((Operator)keyMapper1);
            join.setSecondInput((Operator)keyMapper2);
            keyMapper1.setInput(input1);
            keyMapper2.setInput(input2);
            keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
            keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
            return join;
        }

        private static <I1, I2, K, OUT> PlanUnwrappingJoinOperator<I1, I2, OUT, K> translateSelectorFunctionJoinRight(int[] logicalKeyPositions1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
            if (!inputType1.isTupleType()) {
                throw new InvalidParameterException("Should not happen.");
            }
            Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
            TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys2.getKeyType(), inputType1);
            TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
            TupleKeyExtractingMapper extractor1 = new TupleKeyExtractingMapper(logicalKeyPositions1[0]);
            KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
            MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
            MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
            PlanUnwrappingJoinOperator join = new PlanUnwrappingJoinOperator(function, logicalKeyPositions1, keys2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
            join.setFirstInput((Operator)keyMapper1);
            join.setSecondInput((Operator)keyMapper2);
            keyMapper1.setInput(input1);
            keyMapper2.setInput(input2);
            keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
            keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
            return join;
        }

        private static <I1, I2, K, OUT> PlanUnwrappingJoinOperator<I1, I2, OUT, K> translateSelectorFunctionJoinLeft(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, int[] logicalKeyPositions2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
            if (!inputType2.isTupleType()) {
                throw new InvalidParameterException("Should not happen.");
            }
            Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
            TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
            TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys1.getKeyType(), inputType2);
            KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
            TupleKeyExtractingMapper extractor2 = new TupleKeyExtractingMapper(logicalKeyPositions2[0]);
            MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
            MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
            PlanUnwrappingJoinOperator join = new PlanUnwrappingJoinOperator(function, keys1, logicalKeyPositions2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
            join.setFirstInput((Operator)keyMapper1);
            join.setSecondInput((Operator)keyMapper2);
            keyMapper1.setInput(input1);
            keyMapper2.setInput(input2);
            keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
            keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
            return join;
        }
    }

    public static enum JoinHint {
        OPTIMIZER_CHOOSES,
        BROADCAST_HASH_FIRST,
        BROADCAST_HASH_SECOND,
        REPARTITION_HASH_FIRST,
        REPARTITION_HASH_SECOND,
        REPARTITION_SORT_MERGE;

    }
}

