/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.PrintStream;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;

public class PrintingOutputFormat<T>
implements OutputFormat<T> {
    private static final long serialVersionUID = 1L;
    private static final boolean STD_OUT = false;
    private static final boolean STD_ERR = true;
    private boolean target;
    private transient PrintStream stream;
    private transient String prefix;

    public PrintingOutputFormat() {
    }

    public PrintingOutputFormat(boolean stdErr) {
        this.target = stdErr;
    }

    public void setTargetToStandardOut() {
        this.target = false;
    }

    public void setTargetToStandardErr() {
        this.target = true;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) {
        this.stream = !this.target ? System.out : System.err;
        this.prefix = numTasks > 1 ? taskNumber + "> " : null;
    }

    public void writeRecord(T record) {
        if (this.prefix != null) {
            this.stream.println(this.prefix + record.toString());
        } else {
            this.stream.println(record.toString());
        }
    }

    public void close() {
        this.stream = null;
        this.prefix = null;
    }

    public String toString() {
        return "Print to " + (!this.target ? "System.out" : "System.err");
    }
}

