/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.StringUtils;

public class CsvInputFormat<OUT extends Tuple>
extends GenericCsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final char DEFAULT_FIELD_DELIMITER = ',';
    private transient Object[] parsedValues;
    private boolean lineDelimiterIsLinebreak = false;

    public CsvInputFormat(Path filePath) {
        super(filePath);
    }

    public CsvInputFormat(Path filePath, Class<?> ... types) {
        this(filePath, DEFAULT_LINE_DELIMITER, ',', types);
    }

    public CsvInputFormat(Path filePath, String lineDelimiter, char fieldDelimiter, Class<?> ... types) {
        super(filePath);
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setFieldTypes(types);
    }

    public void setFieldTypes(Class<?> ... fieldTypes) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            throw new IllegalArgumentException("Field types must not be null or empty.");
        }
        this.setFieldTypesGeneric(fieldTypes);
    }

    public void setFields(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        CsvInputFormat.checkForMonotonousOrder(sourceFieldIndices, fieldTypes);
        this.setFieldsGeneric(sourceFieldIndices, fieldTypes);
    }

    public void setFields(boolean[] sourceFieldMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)sourceFieldMask);
        Preconditions.checkNotNull(fieldTypes);
        this.setFieldsGeneric(sourceFieldMask, fieldTypes);
    }

    public Class<?>[] getFieldTypes() {
        return super.getGenericFieldTypes();
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        if (fieldParsers.length == 0) {
            throw new IOException("CsvInputFormat.open(FileInputSplit split) - no field parsers to parse input");
        }
        this.parsedValues = new Object[fieldParsers.length];
        for (int i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
    }

    public OUT readRecord(OUT reuse, byte[] bytes, int offset, int numBytes) {
        if (this.lineDelimiterIsLinebreak && numBytes > 0 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            for (int i = 0; i < this.parsedValues.length; ++i) {
                ((Tuple)reuse).setField((Object)this.parsedValues[i], i);
            }
            return reuse;
        }
        return null;
    }

    public String toString() {
        return "CSV Input (" + StringUtils.showControlCharacters((String)String.valueOf(this.getFieldDelimiter())) + ") " + this.getFilePath();
    }

    private static void checkAndCoSort(int[] positions, Class<?>[] types) {
        int i;
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        TreeMap map = new TreeMap();
        for (i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (map.containsKey(positions[i])) {
                throw new IllegalArgumentException("The position " + positions[i] + " occurs multiple times.");
            }
            map.put(positions[i], types[i]);
        }
        i = 0;
        for (Map.Entry entry : map.entrySet()) {
            positions[i] = (Integer)entry.getKey();
            types[i] = (Class)entry.getValue();
            ++i;
        }
    }

    private static void checkForMonotonousOrder(int[] positions, Class<?>[] types) {
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        int lastPos = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (positions[i] <= lastPos) {
                throw new IllegalArgumentException("The positions must be strictly increasing (no permutations are supported).");
            }
            lastPos = positions[i];
        }
    }
}

