/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.aggregation;

import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;

public abstract class SumAggregationFunction<T>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "SUM";
    }

    public static final class SumAggregationFunctionFactory
    implements AggregationFunctionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public <T> AggregationFunction<T> createAggregationFunction(Class<T> type) {
            if (type == Long.class) {
                return new LongSumAgg();
            }
            if (type == Integer.class) {
                return new IntSumAgg();
            }
            if (type == Double.class) {
                return new DoubleSumAgg();
            }
            if (type == Float.class) {
                return new FloatSumAgg();
            }
            if (type == Byte.class) {
                return new ByteSumAgg();
            }
            if (type == Short.class) {
                return new ShortSumAgg();
            }
            throw new UnsupportedAggregationTypeException("The type " + type.getName() + " has currently not supported for built-in sum aggregations.");
        }
    }

    public static final class DoubleSumAgg
    extends SumAggregationFunction<Double> {
        private static final long serialVersionUID = 1L;
        private double agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0.0;
        }

        @Override
        public void aggregate(Double value) {
            this.agg += value.doubleValue();
        }

        @Override
        public Double getAggregate() {
            return this.agg;
        }
    }

    public static final class FloatSumAgg
    extends SumAggregationFunction<Float> {
        private static final long serialVersionUID = 1L;
        private float agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0.0f;
        }

        @Override
        public void aggregate(Float value) {
            this.agg += value.floatValue();
        }

        @Override
        public Float getAggregate() {
            return Float.valueOf(this.agg);
        }
    }

    public static final class LongSumAgg
    extends SumAggregationFunction<Long> {
        private static final long serialVersionUID = 1L;
        private long agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Long value) {
            this.agg += value.longValue();
        }

        @Override
        public Long getAggregate() {
            return this.agg;
        }
    }

    public static final class IntSumAgg
    extends SumAggregationFunction<Integer> {
        private static final long serialVersionUID = 1L;
        private long agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Integer value) {
            this.agg += (long)value.intValue();
        }

        @Override
        public Integer getAggregate() {
            return (int)this.agg;
        }
    }

    public static final class ShortSumAgg
    extends SumAggregationFunction<Short> {
        private static final long serialVersionUID = 1L;
        private long agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Short value) {
            this.agg += (long)value.shortValue();
        }

        @Override
        public Short getAggregate() {
            return (short)this.agg;
        }
    }

    public static final class ByteSumAgg
    extends SumAggregationFunction<Byte> {
        private static final long serialVersionUID = 1L;
        private long agg;

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Byte value) {
            this.agg += (long)value.byteValue();
        }

        @Override
        public Byte getAggregate() {
            return (byte)this.agg;
        }
    }
}

