/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.KeyRemovingMapper;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class PartitionOperator<T>
extends SingleInputOperator<T, T, PartitionOperator<T>> {
    private final Keys<T> pKeys;
    private final PartitionOperatorBase.PartitionMethod pMethod;
    private final String partitionLocationName;
    private final Partitioner<?> customPartitioner;

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, String partitionLocationName) {
        this(input, pMethod, pKeys, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, String partitionLocationName) {
        this(input, pMethod, null, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<?> customPartitioner, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, null, partitionLocationName);
    }

    public <P> PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, partitionerTypeInfo, partitionLocationName);
    }

    private <P> PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, String partitionLocationName) {
        super(input, input.getType());
        Preconditions.checkNotNull(pMethod);
        Preconditions.checkArgument(pKeys != null || pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE, "Partitioning requires keys");
        Preconditions.checkArgument(pMethod != PartitionOperatorBase.PartitionMethod.CUSTOM || customPartitioner != null, "Custom partioning requires a partitioner.");
        Preconditions.checkArgument(pMethod != PartitionOperatorBase.PartitionMethod.RANGE, "Range partitioning is not yet supported");
        if (pKeys instanceof Keys.ExpressionKeys && !(input.getType() instanceof CompositeType)) {
            throw new IllegalArgumentException("Hash Partitioning with key fields only possible on Tuple or POJO DataSets");
        }
        if (customPartitioner != null) {
            pKeys.validateCustomPartitioner(customPartitioner, partitionerTypeInfo);
        }
        this.pMethod = pMethod;
        this.pKeys = pKeys;
        this.partitionLocationName = partitionLocationName;
        this.customPartitioner = customPartitioner;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    protected org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlow(Operator<T> input) {
        String name = "Partition at " + this.partitionLocationName;
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
            PartitionOperatorBase noop = new PartitionOperatorBase(operatorInfo, this.pMethod, name);
            noop.setInput(input);
            noop.setParallelism(this.getParallelism());
            return noop;
        }
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.HASH || this.pMethod == PartitionOperatorBase.PartitionMethod.CUSTOM) {
            if (this.pKeys instanceof Keys.ExpressionKeys) {
                int[] logicalKeyPositions = this.pKeys.computeLogicalKeyPositions();
                UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
                PartitionOperatorBase noop = new PartitionOperatorBase(operatorInfo, this.pMethod, logicalKeyPositions, name);
                noop.setInput(input);
                noop.setParallelism(this.getParallelism());
                noop.setCustomPartitioner(this.customPartitioner);
                return noop;
            }
            if (this.pKeys instanceof Keys.SelectorFunctionKeys) {
                Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.pKeys;
                MapOperatorBase po = PartitionOperator.translateSelectorFunctionPartitioner(selectorKeys, this.pMethod, this.getType(), name, input, this.getParallelism(), this.customPartitioner);
                return po;
            }
            throw new UnsupportedOperationException("Unrecognized key type.");
        }
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.RANGE) {
            throw new UnsupportedOperationException("Range partitioning not yet supported");
        }
        throw new UnsupportedOperationException("Unsupported partitioning method: " + this.pMethod.name());
    }

    private static <T, K> MapOperatorBase<Tuple2<K, T>, T, ?> translateSelectorFunctionPartitioner(Keys.SelectorFunctionKeys<T, ?> rawKeys, PartitionOperatorBase.PartitionMethod pMethod, TypeInformation<T> inputType, String name, Operator<T> input, int partitionDop, Partitioner<?> customPartitioner) {
        Keys.SelectorFunctionKeys<T, ?> keys = rawKeys;
        TupleTypeInfo typeInfoWithKey = new TupleTypeInfo(keys.getKeyType(), inputType);
        UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(typeInfoWithKey, typeInfoWithKey);
        KeyExtractingMapper extractor = new KeyExtractingMapper(keys.getKeyExtractor());
        MapOperatorBase keyExtractingMap = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        PartitionOperatorBase noop = new PartitionOperatorBase(operatorInfo, pMethod, new int[]{0}, name);
        MapOperatorBase keyRemovingMap = new MapOperatorBase(new KeyRemovingMapper(), new UnaryOperatorInformation(typeInfoWithKey, inputType), "Key Extractor");
        keyExtractingMap.setInput(input);
        noop.setInput((Operator)keyExtractingMap);
        keyRemovingMap.setInput((Operator)noop);
        noop.setCustomPartitioner(customPartitioner);
        keyExtractingMap.setParallelism(input.getParallelism());
        noop.setParallelism(partitionDop);
        keyRemovingMap.setParallelism(partitionDop);
        return keyRemovingMap;
    }
}

