/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FirstReducer;
import org.apache.flink.api.java.functions.FormattingMapper;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.SelectByMaxFunction;
import org.apache.flink.api.java.functions.SelectByMinFunction;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.CustomUnaryOperation;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.SortPartitionOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.operators.join.JoinOperatorSetsBase;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.AbstractID;

public abstract class DataSet<T> {
    protected final ExecutionEnvironment context;
    private TypeInformation<T> type;
    private boolean typeUsed = false;

    protected DataSet(ExecutionEnvironment context, TypeInformation<T> typeInfo) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (typeInfo == null) {
            throw new NullPointerException("typeInfo is null");
        }
        this.context = context;
        this.type = typeInfo;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.context;
    }

    protected void fillInType(TypeInformation<T> typeInfo) {
        if (this.typeUsed) {
            throw new IllegalStateException("TypeInformation cannot be filled in for the type after it has been used. Please make sure that the type info hints are the first call after the transformation function, before any access to types or semantic properties, etc.");
        }
        this.type = typeInfo;
    }

    public TypeInformation<T> getType() {
        if (this.type instanceof MissingTypeInfo) {
            MissingTypeInfo typeInfo = (MissingTypeInfo)this.type;
            throw new InvalidTypesException("The return type of function '" + typeInfo.getFunctionName() + "' could not be determined automatically, due to type erasure. " + "You can give type information hints by using the returns(...) method on the result of " + "the transformation call, or by letting your function implement the 'ResultTypeQueryable' " + "interface.", (Throwable)typeInfo.getTypeException());
        }
        this.typeUsed = true;
        return this.type;
    }

    public <F> F clean(F f) {
        if (this.getExecutionEnvironment().getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, true);
        } else {
            ClosureCleaner.ensureSerializable(f);
        }
        return f;
    }

    public <R> MapOperator<T, R> map(MapFunction<T, R> mapper) {
        if (mapper == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        String callLocation = Utils.getCallLocationName();
        TypeInformation<R> resultType = TypeExtractor.getMapReturnTypes(mapper, this.getType(), callLocation, true);
        return new MapOperator<T, R>(this, resultType, this.clean(mapper), callLocation);
    }

    public <R> MapPartitionOperator<T, R> mapPartition(MapPartitionFunction<T, R> mapPartition) {
        if (mapPartition == null) {
            throw new NullPointerException("MapPartition function must not be null.");
        }
        String callLocation = Utils.getCallLocationName();
        TypeInformation<R> resultType = TypeExtractor.getMapPartitionReturnTypes(mapPartition, this.getType(), callLocation, true);
        return new MapPartitionOperator<T, R>(this, resultType, this.clean(mapPartition), callLocation);
    }

    public <R> FlatMapOperator<T, R> flatMap(FlatMapFunction<T, R> flatMapper) {
        if (flatMapper == null) {
            throw new NullPointerException("FlatMap function must not be null.");
        }
        String callLocation = Utils.getCallLocationName();
        TypeInformation<R> resultType = TypeExtractor.getFlatMapReturnTypes(flatMapper, this.getType(), callLocation, true);
        return new FlatMapOperator<T, R>(this, resultType, this.clean(flatMapper), callLocation);
    }

    public FilterOperator<T> filter(FilterFunction<T> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        return new FilterOperator<T>(this, this.clean(filter), Utils.getCallLocationName());
    }

    public <OUT extends Tuple> ProjectOperator<?, OUT> project(int ... fieldIndexes) {
        return new ProjectOperator.Projection(this, fieldIndexes).projectTupleX();
    }

    public AggregateOperator<T> aggregate(Aggregations agg, int field) {
        return new AggregateOperator(this, agg, field, Utils.getCallLocationName());
    }

    public AggregateOperator<T> sum(int field) {
        return this.aggregate(Aggregations.SUM, field);
    }

    public AggregateOperator<T> max(int field) {
        return this.aggregate(Aggregations.MAX, field);
    }

    public AggregateOperator<T> min(int field) {
        return this.aggregate(Aggregations.MIN, field);
    }

    public long count() throws Exception {
        String id = new AbstractID().toString();
        ((FlatMapOperator)this.flatMap((FlatMapFunction)new Utils.CountHelper(id)).name("count()")).output(new DiscardingOutputFormat()).name("count() sink");
        JobExecutionResult res = this.getExecutionEnvironment().execute();
        return (Long)res.getAccumulatorResult(id);
    }

    public List<T> collect() throws Exception {
        String id = new AbstractID().toString();
        TypeSerializer serializer = this.getType().createSerializer(this.getExecutionEnvironment().getConfig());
        ((FlatMapOperator)this.flatMap((FlatMapFunction)new Utils.CollectHelper(id, serializer)).name("collect()")).output(new DiscardingOutputFormat()).name("collect() sink");
        JobExecutionResult res = this.getExecutionEnvironment().execute();
        ArrayList accResult = (ArrayList)res.getAccumulatorResult(id);
        if (accResult != null) {
            try {
                return SerializedListAccumulator.deserializeList((ArrayList)accResult, (TypeSerializer)serializer);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot find type class of collected data type.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Serialization error while deserializing collected data", e);
            }
        }
        throw new RuntimeException("The call to collect() could not retrieve the DataSet.");
    }

    public ReduceOperator<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return new ReduceOperator<T>(this, this.clean(reducer), Utils.getCallLocationName());
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        String callLocation = Utils.getCallLocationName();
        TypeInformation<R> resultType = TypeExtractor.getGroupReduceReturnTypes(reducer, this.getType(), callLocation, true);
        return new GroupReduceOperator<T, R>(this, resultType, this.clean(reducer), callLocation);
    }

    public <R> GroupCombineOperator<T, R> combineGroup(GroupCombineFunction<T, R> combiner) {
        if (combiner == null) {
            throw new NullPointerException("GroupCombine function must not be null.");
        }
        String callLocation = Utils.getCallLocationName();
        TypeInformation<R> resultType = TypeExtractor.getGroupCombineReturnTypes(combiner, this.getType(), callLocation, true);
        return new GroupCombineOperator<T, R>(this, resultType, this.clean(combiner), callLocation);
    }

    public ReduceOperator<T> minBy(int ... fields) {
        if (!this.getType().isTupleType()) {
            throw new InvalidProgramException("DataSet#minBy(int...) only works on Tuple types.");
        }
        return new ReduceOperator(this, new SelectByMinFunction((TupleTypeInfo)this.getType(), fields), Utils.getCallLocationName());
    }

    public ReduceOperator<T> maxBy(int ... fields) {
        if (!this.getType().isTupleType()) {
            throw new InvalidProgramException("DataSet#maxBy(int...) only works on Tuple types.");
        }
        return new ReduceOperator(this, new SelectByMaxFunction((TupleTypeInfo)this.getType(), fields), Utils.getCallLocationName());
    }

    public GroupReduceOperator<T, T> first(int n) {
        if (n < 1) {
            throw new InvalidProgramException("Parameter n of first(n) must be at least 1.");
        }
        return this.reduceGroup(new FirstReducer(n));
    }

    public <K> DistinctOperator<T> distinct(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.getType());
        return new DistinctOperator(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType(), keyType), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct(int ... fields) {
        return new DistinctOperator<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType(), true), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct(String ... fields) {
        return new DistinctOperator<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType()), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct() {
        return new DistinctOperator(this, null, Utils.getCallLocationName());
    }

    public <K> UnsortedGrouping<T> groupBy(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.getType());
        return new UnsortedGrouping(this, new Keys.SelectorFunctionKeys<T, K>(this.clean(keyExtractor), this.getType(), keyType));
    }

    public UnsortedGrouping<T> groupBy(int ... fields) {
        return new UnsortedGrouping<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType(), false));
    }

    public UnsortedGrouping<T> groupBy(String ... fields) {
        return new UnsortedGrouping<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType()));
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> join(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> join(DataSet<R> other, JoinOperatorBase.JoinHint strategy) {
        return new JoinOperator.JoinOperatorSets(this, other, strategy);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithTiny(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithHuge(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    public <R> JoinOperatorSetsBase<T, R> leftOuterJoin(DataSet<R> other) {
        return new JoinOperatorSetsBase(this, other, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES, JoinType.LEFT_OUTER);
    }

    public <R> JoinOperatorSetsBase<T, R> leftOuterJoin(DataSet<R> other, JoinOperatorBase.JoinHint strategy) {
        switch (strategy) {
            case OPTIMIZER_CHOOSES: 
            case REPARTITION_SORT_MERGE: 
            case REPARTITION_HASH_SECOND: 
            case BROADCAST_HASH_SECOND: {
                return new JoinOperatorSetsBase(this, other, strategy, JoinType.LEFT_OUTER);
            }
        }
        throw new InvalidProgramException("Invalid JoinHint for LeftOuterJoin: " + strategy);
    }

    public <R> JoinOperatorSetsBase<T, R> rightOuterJoin(DataSet<R> other) {
        return new JoinOperatorSetsBase(this, other, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES, JoinType.RIGHT_OUTER);
    }

    public <R> JoinOperatorSetsBase<T, R> rightOuterJoin(DataSet<R> other, JoinOperatorBase.JoinHint strategy) {
        switch (strategy) {
            case OPTIMIZER_CHOOSES: 
            case REPARTITION_SORT_MERGE: 
            case REPARTITION_HASH_FIRST: 
            case BROADCAST_HASH_FIRST: {
                return new JoinOperatorSetsBase(this, other, strategy, JoinType.RIGHT_OUTER);
            }
        }
        throw new InvalidProgramException("Invalid JoinHint for RightOuterJoin: " + strategy);
    }

    public <R> JoinOperatorSetsBase<T, R> fullOuterJoin(DataSet<R> other) {
        return new JoinOperatorSetsBase(this, other, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES, JoinType.FULL_OUTER);
    }

    public <R> JoinOperatorSetsBase<T, R> fullOuterJoin(DataSet<R> other, JoinOperatorBase.JoinHint strategy) {
        switch (strategy) {
            case OPTIMIZER_CHOOSES: 
            case REPARTITION_SORT_MERGE: {
                return new JoinOperatorSetsBase(this, other, strategy, JoinType.FULL_OUTER);
            }
        }
        throw new InvalidProgramException("Invalid JoinHint for FullOuterJoin: " + strategy);
    }

    public <R> CoGroupOperator.CoGroupOperatorSets<T, R> coGroup(DataSet<R> other) {
        return new CoGroupOperator.CoGroupOperatorSets(this, other);
    }

    public <R> CrossOperator.DefaultCross<T, R> cross(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, CrossOperatorBase.CrossHint.OPTIMIZER_CHOOSES, Utils.getCallLocationName());
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithTiny(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, CrossOperatorBase.CrossHint.SECOND_IS_SMALL, Utils.getCallLocationName());
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithHuge(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, CrossOperatorBase.CrossHint.FIRST_IS_SMALL, Utils.getCallLocationName());
    }

    public IterativeDataSet<T> iterate(int maxIterations) {
        return new IterativeDataSet<T>(this.getExecutionEnvironment(), this.getType(), this, maxIterations);
    }

    public <R> DeltaIteration<T, R> iterateDelta(DataSet<R> workset, int maxIterations, int ... keyPositions) {
        Preconditions.checkNotNull(workset);
        Preconditions.checkNotNull(keyPositions);
        Keys.ExpressionKeys<T> keys = new Keys.ExpressionKeys<T>(keyPositions, this.getType(), false);
        return new DeltaIteration<T, R>(this.getExecutionEnvironment(), this.getType(), this, workset, keys, maxIterations);
    }

    public <X> DataSet<X> runOperation(CustomUnaryOperation<T, X> operation) {
        Preconditions.checkNotNull(operation, "The custom operator must not be null.");
        operation.setInput(this);
        return operation.createResult();
    }

    public UnionOperator<T> union(DataSet<T> other) {
        return new UnionOperator<T>(this, other, Utils.getCallLocationName());
    }

    public PartitionOperator<T> partitionByHash(int ... fields) {
        return new PartitionOperator<T>(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.ExpressionKeys<T>(fields, this.getType(), false), Utils.getCallLocationName());
    }

    public PartitionOperator<T> partitionByHash(String ... fields) {
        return new PartitionOperator<T>(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.ExpressionKeys<T>(fields, this.getType()), Utils.getCallLocationName());
    }

    public <K extends Comparable<K>> PartitionOperator<T> partitionByHash(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.getType());
        return new PartitionOperator(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.SelectorFunctionKeys<T, K>(this.clean(keyExtractor), this.getType(), keyType), Utils.getCallLocationName());
    }

    public <K> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, int field) {
        return new PartitionOperator<T>(this, new Keys.ExpressionKeys<T>(new int[]{field}, this.getType(), false), this.clean(partitioner), Utils.getCallLocationName());
    }

    public <K> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, String field) {
        return new PartitionOperator<T>(this, new Keys.ExpressionKeys<T>(new String[]{field}, this.getType()), this.clean(partitioner), Utils.getCallLocationName());
    }

    public <K extends Comparable<K>> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.getType());
        return new PartitionOperator(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType(), keyType), this.clean(partitioner), Utils.getCallLocationName());
    }

    public PartitionOperator<T> rebalance() {
        return new PartitionOperator(this, PartitionOperatorBase.PartitionMethod.REBALANCE, Utils.getCallLocationName());
    }

    public SortPartitionOperator<T> sortPartition(int field, Order order) {
        return new SortPartitionOperator(this, field, order, Utils.getCallLocationName());
    }

    public SortPartitionOperator<T> sortPartition(String field, Order order) {
        return new SortPartitionOperator(this, field, order, Utils.getCallLocationName());
    }

    public DataSink<T> writeAsText(String filePath) {
        return this.output((OutputFormat<T>)new TextOutputFormat(new Path(filePath)));
    }

    public DataSink<T> writeAsText(String filePath, FileSystem.WriteMode writeMode) {
        TextOutputFormat tof = new TextOutputFormat(new Path(filePath));
        tof.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)tof);
    }

    public DataSink<String> writeAsFormattedText(String filePath, TextOutputFormat.TextFormatter<T> formatter) {
        return this.map(new FormattingMapper<T>(this.clean(formatter))).writeAsText(filePath);
    }

    public DataSink<String> writeAsFormattedText(String filePath, FileSystem.WriteMode writeMode, TextOutputFormat.TextFormatter<T> formatter) {
        return this.map(new FormattingMapper<T>(this.clean(formatter))).writeAsText(filePath, writeMode);
    }

    public DataSink<T> writeAsCsv(String filePath) {
        return this.writeAsCsv(filePath, "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
    }

    public DataSink<T> writeAsCsv(String filePath, FileSystem.WriteMode writeMode) {
        return this.internalWriteAsCsv(new Path(filePath), "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER, writeMode);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, null);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode writeMode) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, writeMode);
    }

    private <X extends Tuple> DataSink<T> internalWriteAsCsv(Path filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode wm) {
        Preconditions.checkArgument(this.getType().isTupleType(), "The writeAsCsv() method can only be used on data sets of tuples.");
        CsvOutputFormat of = new CsvOutputFormat(filePath, rowDelimiter, fieldDelimiter);
        if (wm != null) {
            of.setWriteMode(wm);
        }
        return this.output((OutputFormat<T>)of);
    }

    public void print() throws Exception {
        List<T> elements = this.collect();
        for (T e : elements) {
            System.out.println(e);
        }
    }

    public void printToErr() throws Exception {
        List<T> elements = this.collect();
        for (T e : elements) {
            System.err.println(e);
        }
    }

    public DataSink<T> printOnTaskManager(String prefix) {
        return this.output((OutputFormat<T>)new PrintingOutputFormat(prefix, false));
    }

    @Deprecated
    public DataSink<T> print(String sinkIdentifier) {
        return this.output((OutputFormat<T>)new PrintingOutputFormat(sinkIdentifier, false));
    }

    @Deprecated
    public DataSink<T> printToErr(String sinkIdentifier) {
        return this.output((OutputFormat<T>)new PrintingOutputFormat(sinkIdentifier, true));
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath) {
        Preconditions.checkNotNull(filePath, "File path must not be null.");
        Preconditions.checkNotNull(outputFormat, "Output format must not be null.");
        outputFormat.setOutputFilePath(new Path(filePath));
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath, FileSystem.WriteMode writeMode) {
        Preconditions.checkNotNull(filePath, "File path must not be null.");
        Preconditions.checkNotNull(writeMode, "Write mode must not be null.");
        Preconditions.checkNotNull(outputFormat, "Output format must not be null.");
        outputFormat.setOutputFilePath(new Path(filePath));
        outputFormat.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> output(OutputFormat<T> outputFormat) {
        Preconditions.checkNotNull(outputFormat);
        if (outputFormat instanceof InputTypeConfigurable) {
            ((InputTypeConfigurable)outputFormat).setInputType(this.getType(), this.context.getConfig());
        }
        DataSink<T> sink = new DataSink<T>(this, outputFormat, this.getType());
        this.context.registerDataSink(sink);
        return sink;
    }

    protected static void checkSameExecutionContext(DataSet<?> set1, DataSet<?> set2) {
        if (set1.context != set2.context) {
            throw new IllegalArgumentException("The two inputs have different execution contexts.");
        }
    }
}

