/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.java.sampling.BernoulliSampler;
import org.apache.flink.api.java.sampling.PoissonSampler;
import org.apache.flink.api.java.sampling.RandomSampler;
import org.apache.flink.util.Collector;

public class SampleWithFraction<T>
extends RichMapPartitionFunction<T, T> {
    private boolean withReplacement;
    private double fraction;
    private long seed;

    public SampleWithFraction(boolean withReplacement, double fraction, long seed) {
        this.withReplacement = withReplacement;
        this.fraction = fraction;
        this.seed = seed;
    }

    public void mapPartition(Iterable<T> values, Collector<T> out) throws Exception {
        long seedAndIndex = this.seed + (long)this.getRuntimeContext().getIndexOfThisSubtask();
        RandomSampler sampler = this.withReplacement ? new PoissonSampler(this.fraction, seedAndIndex) : new BernoulliSampler(this.fraction, seedAndIndex);
        Iterator<T> sampled = sampler.sample(values.iterator());
        while (sampled.hasNext()) {
            out.collect(sampled.next());
        }
    }
}

