/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewObjectInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewObjectOutputStreamWrapper;

public class CollectionInputFormat<T>
extends GenericInputFormat<T>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private TypeSerializer<T> serializer;
    private transient Collection<T> dataSet;
    private transient Iterator<T> iterator;

    public CollectionInputFormat(Collection<T> dataSet, TypeSerializer<T> serializer) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.serializer = serializer;
        this.dataSet = dataSet;
    }

    public boolean reachedEnd() throws IOException {
        return !this.iterator.hasNext();
    }

    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.iterator = this.dataSet.iterator();
    }

    public T nextRecord(T record) throws IOException {
        return this.iterator.next();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int size = this.dataSet.size();
        out.writeInt(size);
        if (size > 0) {
            OutputViewObjectOutputStreamWrapper wrapper = new OutputViewObjectOutputStreamWrapper(out);
            for (T element : this.dataSet) {
                this.serializer.serialize(element, (DataOutputView)wrapper);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int collectionLength = in.readInt();
        ArrayList<T> list = new ArrayList<T>(collectionLength);
        if (collectionLength > 0) {
            try {
                InputViewObjectInputStreamWrapper wrapper = new InputViewObjectInputStreamWrapper(in);
                for (int i = 0; i < collectionLength; ++i) {
                    Object element = this.serializer.deserialize((DataInputView)wrapper);
                    list.add(element);
                }
            }
            catch (Throwable t) {
                throw new IOException("Error while deserializing element from collection", t);
            }
        }
        this.dataSet = list;
    }

    public String toString() {
        return this.dataSet.toString();
    }

    public static <X> void checkCollection(Collection<X> elements, Class<X> viewedAs) {
        if (elements == null || viewedAs == null) {
            throw new NullPointerException();
        }
        for (X elem : elements) {
            if (elem == null) {
                throw new IllegalArgumentException("The collection must not contain null elements.");
            }
            if (viewedAs.isAssignableFrom(elem.getClass()) || elem.getClass().toString().equals("class scala.runtime.BoxedUnit") && viewedAs.equals(Void.TYPE)) continue;
            throw new IllegalArgumentException("The elements in the collection are not all subclasses of " + viewedAs.getCanonicalName());
        }
    }
}

