/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.kafka;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.event.EventType;

public class EventDeSerializationSchema
implements DeserializationSchema<Event>,
SerializationSchema<Event> {
    private static final long serialVersionUID = 1L;

    public byte[] serialize(Event evt) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(0, evt.sourceAddress());
        byteBuffer.putInt(4, evt.type().ordinal());
        return byteBuffer.array();
    }

    public Event deserialize(byte[] message) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(message).order(ByteOrder.LITTLE_ENDIAN);
        int address = buffer.getInt(0);
        int typeOrdinal = buffer.getInt(4);
        return new Event(EventType.values()[typeOrdinal], address);
    }

    public boolean isEndOfStream(Event nextElement) {
        return false;
    }

    public TypeInformation<Event> getProducedType() {
        return TypeInformation.of(Event.class);
    }
}

