/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.datastream.api.stream.DataStream;
import org.apache.flink.datastream.impl.ExecutionEnvironmentImpl;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public abstract class AbstractDataStream<T>
implements DataStream {
    protected final ExecutionEnvironmentImpl environment;
    protected final Transformation<T> transformation;
    protected final Map<OutputTag<?>, TypeInformation<?>> requestedSideOutputs = new HashMap();

    public AbstractDataStream(ExecutionEnvironmentImpl environment, Transformation<T> transformation) {
        this.environment = (ExecutionEnvironmentImpl)Preconditions.checkNotNull((Object)environment, (String)"Execution Environment must not be null.");
        this.transformation = (Transformation)Preconditions.checkNotNull(transformation, (String)"Stream Transformation must not be null.");
    }

    public TypeInformation<T> getType() {
        return this.transformation.getOutputType();
    }

    public Transformation<T> getTransformation() {
        return this.transformation;
    }

    public ExecutionEnvironmentImpl getEnvironment() {
        return this.environment;
    }

    public <X> Transformation<X> getSideOutputTransform(OutputTag<X> outputTag) {
        TypeInformation<?> type = this.requestedSideOutputs.get(outputTag);
        if (type != null && !type.equals((Object)outputTag.getTypeInfo())) {
            throw new UnsupportedOperationException("A side output with a matching id was already requested with a different type. This is not allowed, side output ids need to be unique.");
        }
        this.requestedSideOutputs.put(outputTag, outputTag.getTypeInfo());
        return new SideOutputTransformation(this.getTransformation(), outputTag);
    }
}

