/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.extension.eventtime;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.watermark.BoolWatermarkDeclaration;
import org.apache.flink.api.common.watermark.LongWatermarkDeclaration;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.api.common.watermark.WatermarkDeclarations;
import org.apache.flink.datastream.api.extension.eventtime.function.OneInputEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoInputBroadcastEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoInputNonBroadcastEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoOutputEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeExtractor;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeWatermarkGeneratorBuilder;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;

@Experimental
public class EventTimeExtension {
    public static final LongWatermarkDeclaration EVENT_TIME_WATERMARK_DECLARATION = WatermarkDeclarations.newBuilder((String)"BUILTIN_API_EVENT_TIME").typeLong().combineFunctionMin().combineWaitForAllChannels(true).defaultHandlingStrategyForward().build();
    public static final BoolWatermarkDeclaration IDLE_STATUS_WATERMARK_DECLARATION = WatermarkDeclarations.newBuilder((String)"BUILTIN_API_EVENT_TIME_IDLE").typeBool().combineFunctionAND().combineWaitForAllChannels(true).defaultHandlingStrategyForward().build();

    public static boolean isEventTimeWatermark(Watermark watermark) {
        return EventTimeExtension.isEventTimeWatermark(watermark.getIdentifier());
    }

    public static boolean isEventTimeWatermark(String watermarkIdentifier) {
        return watermarkIdentifier.equals(EVENT_TIME_WATERMARK_DECLARATION.getIdentifier());
    }

    public static boolean isIdleStatusWatermark(Watermark watermark) {
        return EventTimeExtension.isIdleStatusWatermark(watermark.getIdentifier());
    }

    public static boolean isIdleStatusWatermark(String watermarkIdentifier) {
        return watermarkIdentifier.equals(IDLE_STATUS_WATERMARK_DECLARATION.getIdentifier());
    }

    public static <T> EventTimeWatermarkGeneratorBuilder<T> newWatermarkGeneratorBuilder(EventTimeExtractor<T> eventTimeExtractor) {
        return new EventTimeWatermarkGeneratorBuilder<T>(eventTimeExtractor);
    }

    public static <IN, OUT> OneInputStreamProcessFunction<IN, OUT> wrapProcessFunction(OneInputEventTimeStreamProcessFunction<IN, OUT> processFunction) {
        try {
            return (OneInputStreamProcessFunction)EventTimeExtension.getEventTimeExtensionImplClass().getMethod("wrapProcessFunction", OneInputEventTimeStreamProcessFunction.class).invoke(null, processFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <IN, OUT1, OUT2> TwoOutputStreamProcessFunction<IN, OUT1, OUT2> wrapProcessFunction(TwoOutputEventTimeStreamProcessFunction<IN, OUT1, OUT2> processFunction) {
        try {
            return (TwoOutputStreamProcessFunction)EventTimeExtension.getEventTimeExtensionImplClass().getMethod("wrapProcessFunction", TwoOutputEventTimeStreamProcessFunction.class).invoke(null, processFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <IN1, IN2, OUT> TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> wrapProcessFunction(TwoInputNonBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> processFunction) {
        try {
            return (TwoInputNonBroadcastStreamProcessFunction)EventTimeExtension.getEventTimeExtensionImplClass().getMethod("wrapProcessFunction", TwoInputNonBroadcastEventTimeStreamProcessFunction.class).invoke(null, processFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <IN1, IN2, OUT> TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> wrapProcessFunction(TwoInputBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> processFunction) {
        try {
            return (TwoInputBroadcastStreamProcessFunction)EventTimeExtension.getEventTimeExtensionImplClass().getMethod("wrapProcessFunction", TwoInputBroadcastEventTimeStreamProcessFunction.class).invoke(null, processFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getEventTimeExtensionImplClass() {
        try {
            return Class.forName("org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Please ensure that flink-datastream in your class path");
        }
    }
}

