/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiscoveryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableDiscoveryUtils.class);

    public static List<TableId> listTables(String database, JdbcConnection jdbc, RelationalTableFilters tableFilters, boolean includePartitionedTables) throws SQLException {
        String[] tableTypes = new String[]{"TABLE"};
        if (includePartitionedTables) {
            tableTypes = new String[]{"TABLE", "PARTITIONED TABLE"};
        }
        Set allTableIds = jdbc.readTableNames(database, null, null, tableTypes);
        Set capturedTables = allTableIds.stream().filter(t -> tableFilters.dataCollectionFilter().isIncluded(t)).collect(Collectors.toSet());
        LOG.info("Postgres captured tables : {} .", (Object)capturedTables.stream().map(TableId::toString).collect(Collectors.joining(",")));
        return new ArrayList<TableId>(capturedTables);
    }
}

