/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source;

import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfigFactory;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.source.assigner.HybridSplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.SplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.StreamSplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.state.HybridPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.StreamPendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceReaderContext;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceSplitReader;
import org.apache.flink.cdc.connectors.postgres.source.PostgresDialect;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfigFactory;
import org.apache.flink.cdc.connectors.postgres.source.enumerator.PostgresSourceEnumerator;
import org.apache.flink.cdc.connectors.postgres.source.offset.PostgresOffsetFactory;
import org.apache.flink.cdc.connectors.postgres.source.reader.PostgresSourceReader;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Experimental
public class PostgresSourceBuilder<T> {
    private final PostgresSourceConfigFactory configFactory = new PostgresSourceConfigFactory();
    private DebeziumDeserializationSchema<T> deserializer;

    private PostgresSourceBuilder() {
    }

    public PostgresSourceBuilder<T> decodingPluginName(String name) {
        this.configFactory.decodingPluginName(name);
        return this;
    }

    public PostgresSourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public PostgresSourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public PostgresSourceBuilder<T> database(String database) {
        this.configFactory.database(database);
        return this;
    }

    public PostgresSourceBuilder<T> schemaList(String ... schemaList) {
        this.configFactory.schemaList(schemaList);
        return this;
    }

    public PostgresSourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public PostgresSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public PostgresSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public PostgresSourceBuilder<T> slotName(String slotName) {
        this.configFactory.slotName(slotName);
        return this;
    }

    public PostgresSourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public PostgresSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public PostgresSourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public PostgresSourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public PostgresSourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public PostgresSourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public PostgresSourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public PostgresSourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public PostgresSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public PostgresSourceBuilder<T> chunkKeyColumn(String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(chunkKeyColumn);
        return this;
    }

    public PostgresSourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public PostgresSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public PostgresSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public PostgresSourceBuilder<T> heartbeatInterval(Duration heartbeatInterval) {
        this.configFactory.heartbeatInterval(heartbeatInterval);
        return this;
    }

    public PostgresSourceBuilder<T> skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.configFactory.skipSnapshotBackfill(skipSnapshotBackfill);
        return this;
    }

    public PostgresSourceBuilder<T> scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.configFactory.scanNewlyAddedTableEnabled(scanNewlyAddedTableEnabled);
        return this;
    }

    public PostgresSourceBuilder<T> lsnCommitCheckpointsDelay(int lsnCommitDelay) {
        this.configFactory.setLsnCommitCheckpointsDelay(lsnCommitDelay);
        return this;
    }

    public PostgresIncrementalSource<T> build() {
        PostgresOffsetFactory offsetFactory = new PostgresOffsetFactory();
        PostgresDialect dialect = new PostgresDialect(this.configFactory.create(0));
        return new PostgresIncrementalSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer), offsetFactory, dialect);
    }

    @Experimental
    public static class PostgresIncrementalSource<T>
    extends JdbcIncrementalSource<T> {
        public PostgresIncrementalSource(PostgresSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, PostgresOffsetFactory offsetFactory, PostgresDialect dataSourceDialect) {
            super((JdbcSourceConfigFactory)configFactory, deserializationSchema, (OffsetFactory)offsetFactory, (JdbcDataSourceDialect)dataSourceDialect);
        }

        public PostgresSourceEnumerator createEnumerator(SplitEnumeratorContext<SourceSplitBase> enumContext) {
            StreamSplitAssigner splitAssigner;
            PostgresSourceConfig sourceConfig = (PostgresSourceConfig)this.configFactory.create(0);
            if (!sourceConfig.getStartupOptions().isStreamOnly()) {
                try {
                    List remainingTables = this.dataSourceDialect.discoverDataCollections((SourceConfig)sourceConfig);
                    boolean isTableIdCaseSensitive = this.dataSourceDialect.isDataCollectionIdCaseSensitive((SourceConfig)sourceConfig);
                    splitAssigner = new HybridSplitAssigner((SourceConfig)sourceConfig, enumContext.currentParallelism(), remainingTables, isTableIdCaseSensitive, this.dataSourceDialect, this.offsetFactory);
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Failed to discover captured tables for enumerator", (Throwable)e);
                }
            } else {
                splitAssigner = new StreamSplitAssigner((SourceConfig)sourceConfig, this.dataSourceDialect, this.offsetFactory);
            }
            return new PostgresSourceEnumerator(enumContext, sourceConfig, (SplitAssigner)splitAssigner, (PostgresDialect)this.dataSourceDialect, this.getBoundedness());
        }

        public PostgresSourceEnumerator restoreEnumerator(SplitEnumeratorContext<SourceSplitBase> enumContext, PendingSplitsState checkpoint) {
            HybridSplitAssigner splitAssigner;
            PostgresSourceConfig sourceConfig = (PostgresSourceConfig)this.configFactory.create(0);
            if (checkpoint instanceof HybridPendingSplitsState) {
                splitAssigner = new HybridSplitAssigner((SourceConfig)sourceConfig, enumContext.currentParallelism(), (HybridPendingSplitsState)checkpoint, this.dataSourceDialect, this.offsetFactory);
            } else if (checkpoint instanceof StreamPendingSplitsState) {
                splitAssigner = new StreamSplitAssigner((SourceConfig)sourceConfig, (StreamPendingSplitsState)checkpoint, this.dataSourceDialect, this.offsetFactory);
            } else {
                throw new UnsupportedOperationException("Unsupported restored PendingSplitsState: " + checkpoint);
            }
            return new PostgresSourceEnumerator(enumContext, sourceConfig, (SplitAssigner)splitAssigner, (PostgresDialect)this.dataSourceDialect, this.getBoundedness());
        }

        public PostgresSourceReader createReader(SourceReaderContext readerContext) throws Exception {
            PostgresSourceConfig sourceConfig = (PostgresSourceConfig)this.configFactory.create(readerContext.getIndexOfSubtask());
            FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
            SourceReaderMetrics sourceReaderMetrics = new SourceReaderMetrics(readerContext.metricGroup());
            sourceReaderMetrics.registerMetrics();
            IncrementalSourceReaderContext incrementalSourceReaderContext = new IncrementalSourceReaderContext(readerContext);
            Supplier<IncrementalSourceSplitReader> splitReaderSupplier = () -> new IncrementalSourceSplitReader(readerContext.getIndexOfSubtask(), this.dataSourceDialect, (SourceConfig)sourceConfig, incrementalSourceReaderContext, this.snapshotHooks);
            return new PostgresSourceReader(elementsQueue, splitReaderSupplier, this.createRecordEmitter((SourceConfig)sourceConfig, sourceReaderMetrics), readerContext.getConfiguration(), incrementalSourceReaderContext, (SourceConfig)sourceConfig, this.sourceSplitSerializer, this.dataSourceDialect);
        }

        public static <T> PostgresSourceBuilder<T> builder() {
            return new PostgresSourceBuilder();
        }
    }
}

