/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresPartition;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.util.FlinkRuntimeException;

public class CustomPostgresSchema {
    private final Map<TableId, TableChanges.TableChange> schemasByTableId = new HashMap<TableId, TableChanges.TableChange>();
    private final PostgresConnection jdbcConnection;
    private final PostgresConnectorConfig dbzConfig;

    public CustomPostgresSchema(PostgresConnection jdbcConnection, PostgresSourceConfig sourceConfig) {
        this.jdbcConnection = jdbcConnection;
        this.dbzConfig = sourceConfig.getDbzConnectorConfig();
    }

    public TableChanges.TableChange getTableSchema(TableId tableId) {
        if (!this.schemasByTableId.containsKey(tableId)) {
            try {
                this.readTableSchema(tableId);
            }
            catch (SQLException e) {
                throw new FlinkRuntimeException("Failed to read table schema", (Throwable)e);
            }
        }
        return this.schemasByTableId.get(tableId);
    }

    private TableChanges.TableChange readTableSchema(TableId tableId) throws SQLException {
        PostgresOffsetContext offsetContext = PostgresOffsetContext.initialContext((PostgresConnectorConfig)this.dbzConfig, (PostgresConnection)this.jdbcConnection, (Clock)Clock.SYSTEM);
        PostgresPartition partition = new PostgresPartition(this.dbzConfig.getLogicalName());
        offsetContext.event((DataCollectionId)tableId, Instant.now());
        Tables tables = new Tables();
        try {
            this.jdbcConnection.readSchema(tables, this.dbzConfig.databaseName(), tableId.schema(), this.dbzConfig.getTableFilters().dataCollectionFilter(), null, false);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to read schema", (Throwable)e);
        }
        Table table = Objects.requireNonNull(tables.forTable(tableId));
        SchemaChangeEvent schemaChangeEvent = SchemaChangeEvent.ofCreate((Partition)partition, (OffsetContext)offsetContext, (String)this.dbzConfig.databaseName(), (String)tableId.schema(), null, (Table)table, (boolean)true);
        for (TableChanges.TableChange tableChange : schemaChangeEvent.getTableChanges()) {
            this.schemasByTableId.put(tableId, tableChange);
        }
        return this.schemasByTableId.get(tableId);
    }
}

