/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.base.utils.SourceRecordUtils;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresQueryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresQueryUtils.class);

    private PostgresQueryUtils() {
    }

    public static Object[] queryMinMax(JdbcConnection jdbc, TableId tableId, String columnName) throws SQLException {
        String minMaxQuery = String.format("SELECT MIN(%s), MAX(%s) FROM %s", PostgresQueryUtils.quote(columnName), PostgresQueryUtils.quote(columnName), PostgresQueryUtils.quote(tableId));
        return (Object[])jdbc.queryAndMap(minMaxQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minMaxQuery));
            }
            return SourceRecordUtils.rowToArray((ResultSet)rs, (int)2);
        });
    }

    public static long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        String query = String.format("SELECT reltuples::bigint FROM pg_class WHERE oid = to_regclass('%s')", tableId.toString());
        return (Long)jdbc.queryAndMap(query, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            LOG.info("queryApproximateRowCnt: {} => {}", (Object)query, (Object)rs.getLong(1));
            return rs.getLong(1);
        });
    }

    public static Object queryMin(JdbcConnection jdbc, TableId tableId, String columnName, Object excludedLowerBound) throws SQLException {
        String query = String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", PostgresQueryUtils.quote(columnName), PostgresQueryUtils.quote(tableId), PostgresQueryUtils.quote(columnName));
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, excludedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            LOG.info("{} => {}", (Object)query, rs.getObject(1));
            return rs.getObject(1);
        });
    }

    public static Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, String splitColumnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = PostgresQueryUtils.quote(splitColumnName);
        String query = String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC LIMIT %s) AS T", quotedColumn, quotedColumn, PostgresQueryUtils.quote(tableId), quotedColumn, quotedColumn, chunkSize);
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, includedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            return rs.getObject(1);
        });
    }

    public static String buildSplitScanQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit) {
        return PostgresQueryUtils.buildSplitQuery(tableId, pkRowType, isFirstSplit, isLastSplit, -1, true);
    }

    private static String buildSplitQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, int limitSize, boolean isScanningData) {
        StringBuilder sql;
        String condition;
        if (isFirstSplit && isLastSplit) {
            condition = null;
        } else if (isFirstSplit) {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            condition = sql.toString();
        } else if (isLastSplit) {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            condition = sql.toString();
        } else {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            sql.append(" AND ");
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            condition = sql.toString();
        }
        if (isScanningData) {
            return PostgresQueryUtils.buildSelectWithRowLimits(tableId, limitSize, "*", Optional.ofNullable(condition), Optional.empty());
        }
        String orderBy = pkRowType.getFieldNames().stream().collect(Collectors.joining(", "));
        return PostgresQueryUtils.buildSelectWithBoundaryRowLimits(tableId, limitSize, PostgresQueryUtils.getPrimaryKeyColumnsProjection(pkRowType), PostgresQueryUtils.getMaxPrimaryKeyColumnsProjection(pkRowType), Optional.ofNullable(condition), orderBy);
    }

    public static PreparedStatement readTableSplitDataStatement(JdbcConnection jdbc, String sql, boolean isFirstSplit, boolean isLastSplit, Object[] splitStart, Object[] splitEnd, int primaryKeyNum, int fetchSize) {
        try {
            PreparedStatement statement = PostgresQueryUtils.initStatement(jdbc, sql, fetchSize);
            if (isFirstSplit && isLastSplit) {
                return statement;
            }
            if (isFirstSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitEnd[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                }
            } else if (isLastSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                }
            } else {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                    statement.setObject(i + 1 + 2 * primaryKeyNum, splitEnd[i]);
                }
            }
            return statement;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build the split data read statement.", e);
        }
    }

    public static String quote(String dbOrTableName) {
        return "\"" + dbOrTableName + "\"";
    }

    public static String quote(TableId tableId) {
        return tableId.toQuotedString('\"');
    }

    private static PreparedStatement initStatement(JdbcConnection jdbc, String sql, int fetchSize) throws SQLException {
        Connection connection = jdbc.connection();
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        return statement;
    }

    private static void addPrimaryKeyColumnsToCondition(RowType pkRowType, StringBuilder sql, String predicate) {
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next()).append(predicate);
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private static String getPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next());
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String getMaxPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append("MAX(" + (String)fieldNamesIt.next() + ")");
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(projection).append(" FROM ");
        sql.append(PostgresQueryUtils.quote(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (orderBy.isPresent()) {
            sql.append(" ORDER BY ").append(orderBy.get());
        }
        if (limit > 0) {
            sql.append(" LIMIT ").append(limit);
        }
        return sql.toString();
    }

    private static String buildSelectWithBoundaryRowLimits(TableId tableId, int limit, String projection, String maxColumnProjection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(maxColumnProjection);
        sql.append(" FROM (");
        sql.append("SELECT ");
        sql.append(projection);
        sql.append(" FROM ");
        sql.append(PostgresQueryUtils.quote(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy).append(" LIMIT ").append(limit);
        sql.append(") T");
        return sql.toString();
    }
}

