/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.runtime.serializer.EnumSerializer;
import org.apache.flink.cdc.runtime.serializer.NullableSerializerWrapper;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.ColumnSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class ColumnWithPositionSerializer
extends TypeSerializerSingleton<AddColumnEvent.ColumnWithPosition> {
    private static final long serialVersionUID = 1L;
    public static final ColumnWithPositionSerializer INSTANCE = new ColumnWithPositionSerializer();
    private final TypeSerializer<Column> addColumnSerializer = new NullableSerializerWrapper<Column>(ColumnSerializer.INSTANCE);
    private final TypeSerializer<String> existedColumnNameSerializer = StringSerializer.INSTANCE;
    private final EnumSerializer<AddColumnEvent.ColumnPosition> positionEnumSerializer = new EnumSerializer<AddColumnEvent.ColumnPosition>(AddColumnEvent.ColumnPosition.class);

    public boolean isImmutableType() {
        return false;
    }

    public AddColumnEvent.ColumnWithPosition createInstance() {
        return new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"unknown", (DataType)DataTypes.BIGINT()));
    }

    public AddColumnEvent.ColumnWithPosition copy(AddColumnEvent.ColumnWithPosition from) {
        return new AddColumnEvent.ColumnWithPosition((Column)this.addColumnSerializer.copy((Object)from.getAddColumn()), from.getPosition(), (String)this.existedColumnNameSerializer.copy((Object)from.getExistedColumnName()));
    }

    public AddColumnEvent.ColumnWithPosition copy(AddColumnEvent.ColumnWithPosition from, AddColumnEvent.ColumnWithPosition reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(AddColumnEvent.ColumnWithPosition record, DataOutputView target) throws IOException {
        this.addColumnSerializer.serialize((Object)record.getAddColumn(), target);
        this.positionEnumSerializer.serialize(record.getPosition(), target);
        this.existedColumnNameSerializer.serialize((Object)record.getExistedColumnName(), target);
    }

    public AddColumnEvent.ColumnWithPosition deserialize(DataInputView source) throws IOException {
        Column addColumn = (Column)this.addColumnSerializer.deserialize(source);
        AddColumnEvent.ColumnPosition position = (AddColumnEvent.ColumnPosition)this.positionEnumSerializer.deserialize(source);
        return new AddColumnEvent.ColumnWithPosition(addColumn, position, (String)this.existedColumnNameSerializer.deserialize(source));
    }

    public AddColumnEvent.ColumnWithPosition deserialize(AddColumnEvent.ColumnWithPosition reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<AddColumnEvent.ColumnWithPosition> snapshotConfiguration() {
        return new ColumnWithPositionSerializerSnapshot();
    }

    public static final class ColumnWithPositionSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<AddColumnEvent.ColumnWithPosition> {
        public ColumnWithPositionSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

