/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.common;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.route.RouteRule;
import org.apache.flink.cdc.common.schema.Selectors;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.guava31.com.google.common.cache.LoadingCache;

public class TableIdRouter {
    private final List<Tuple3<Selectors, String, String>> routes = new ArrayList<Tuple3<Selectors, String, String>>();
    private final LoadingCache<TableId, List<TableId>> routingCache;
    private static final Duration CACHE_EXPIRE_DURATION = Duration.ofDays(1L);

    public TableIdRouter(List<RouteRule> routingRules) {
        for (RouteRule rule : routingRules) {
            try {
                String tableInclusions = rule.sourceTable;
                Selectors selectors = new Selectors.SelectorsBuilder().includeTables(tableInclusions).build();
                this.routes.add((Tuple3<Selectors, String, String>)new Tuple3((Object)selectors, (Object)rule.sinkTable, (Object)rule.replaceSymbol));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.format("Failed to parse regular expression in routing rule %s. Notice that `.` is used to separate Table ID components. To use it as a regex token, put a `\\` before to escape it.", rule), e);
            }
        }
        this.routingCache = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRE_DURATION).build((CacheLoader)new CacheLoader<TableId, List<TableId>>(){

            @Nonnull
            public List<TableId> load(@Nonnull TableId key) {
                return TableIdRouter.this.calculateRoute(key);
            }
        });
    }

    public List<TableId> route(TableId sourceTableId) {
        return (List)this.routingCache.getUnchecked((Object)sourceTableId);
    }

    private List<TableId> calculateRoute(TableId sourceTableId) {
        List<TableId> routedTableIds = this.routes.stream().filter(route -> ((Selectors)route.f0).isMatch(sourceTableId)).map(route -> this.resolveReplacement(sourceTableId, (Tuple3<Selectors, String, String>)route)).collect(Collectors.toList());
        if (routedTableIds.isEmpty()) {
            routedTableIds.add(sourceTableId);
        }
        return routedTableIds;
    }

    private TableId resolveReplacement(TableId originalTable, Tuple3<Selectors, String, String> route) {
        if (route.f2 != null) {
            return TableId.parse((String)((String)route.f1).replace((CharSequence)route.f2, originalTable.getTableName()));
        }
        return TableId.parse((String)((String)route.f1));
    }

    public List<Set<TableId>> groupSourceTablesByRouteRule(Set<TableId> tableIdSet) {
        if (this.routes.isEmpty()) {
            return new ArrayList<Set<TableId>>();
        }
        List<Set<TableId>> routedTableIds = this.routes.stream().map(route -> tableIdSet.stream().filter(tableId -> ((Selectors)route.f0).isMatch(tableId)).collect(Collectors.toSet())).collect(Collectors.toList());
        return routedTableIds;
    }
}

