/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.typeutils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.ArrayType;
import org.apache.flink.cdc.common.types.BinaryType;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.MapType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.types.VarBinaryType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.shaded.guava31.com.google.common.io.BaseEncoding;

public class BinaryRecordDataExtractor {
    @CheckReturnValue
    public static Object extractRecord(RecordData record, Schema schema) {
        return BinaryRecordDataExtractor.extractRecord((Object)record, schema.toRowDataType());
    }

    @CheckReturnValue
    public static Object extractRecord(Object object, DataType dataType) {
        if (object == null) {
            return "null";
        }
        if (dataType instanceof BinaryType || dataType instanceof VarBinaryType) {
            Preconditions.checkArgument((boolean)(object instanceof byte[]), (String)"Column data of BinaryType and VarBinaryType should be `byte[]`, but was %s", (Object[])new Object[]{object.getClass().getName()});
            return BaseEncoding.base64().encode((byte[])object);
        }
        if (dataType instanceof MapType) {
            Preconditions.checkArgument((boolean)(object instanceof MapData), (String)"Column data of MapType should be MapData, but was %s", (Object[])new Object[]{object.getClass().getName()});
            MapType mapType = (MapType)dataType;
            MapData mapData = (MapData)object;
            List keyArray = (List)BinaryRecordDataExtractor.extractRecord(mapData.keyArray(), (DataType)DataTypes.ARRAY((DataType)mapType.getKeyType()));
            List valueArray = (List)BinaryRecordDataExtractor.extractRecord(mapData.valueArray(), (DataType)DataTypes.ARRAY((DataType)mapType.getValueType()));
            Preconditions.checkArgument((keyArray.size() == valueArray.size() ? 1 : 0) != 0, (String)"Malformed MapData: keyArray size (%d) differs from valueArray (%d)", (Object[])new Object[]{keyArray.size(), valueArray.size()});
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < keyArray.size(); ++i) {
                sb.append(keyArray.get(i)).append(" -> ").append(valueArray.get(i)).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            return sb.append("}").toString();
        }
        if (dataType instanceof ArrayType) {
            Preconditions.checkArgument((boolean)(object instanceof ArrayData), (String)"Column data of ArrayType should be ArrayData, but was %s", (Object[])new Object[]{object.getClass().getName()});
            ArrayType arrayType = (ArrayType)dataType;
            ArrayData arrayData = (ArrayData)object;
            ArrayData.ElementGetter getter = ArrayData.createElementGetter((DataType)arrayType.getElementType());
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < arrayData.size(); ++i) {
                results.add(getter.getElementOrNull(arrayData, i));
            }
            return results;
        }
        if (dataType instanceof RowType) {
            Preconditions.checkArgument((boolean)(object instanceof RecordData), (String)"Column data of RowType should be RecordData, but was %s", (Object[])new Object[]{object.getClass().getName()});
            RowType rowType = (RowType)dataType;
            RecordData binaryRecordData = (RecordData)object;
            List fieldNames = rowType.getFieldNames();
            List fieldTypes = rowType.getFieldTypes();
            List fieldGetters = SchemaUtils.createFieldGetters((DataType[])fieldTypes.toArray(new DataType[0]));
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                sb.append((String)fieldNames.get(i)).append(": ").append(fieldTypes.get(i)).append(" -> ").append(BinaryRecordDataExtractor.extractRecord(((RecordData.FieldGetter)fieldGetters.get(i)).getFieldOrNull(binaryRecordData), (DataType)fieldTypes.get(i))).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            return sb.append("}").toString();
        }
        return object.toString();
    }
}

