/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;

public class ProjectionColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Column column;
    private final String expression;
    private final String scriptExpression;
    private final List<String> originalColumnNames;
    private TransformExpressionKey transformExpressionKey;

    public ProjectionColumn(Column column, String expression, String scriptExpression, List<String> originalColumnNames) {
        this.column = column;
        this.expression = expression;
        this.scriptExpression = scriptExpression;
        this.originalColumnNames = originalColumnNames;
    }

    public ProjectionColumn copy() {
        return new ProjectionColumn(this.column.copy(this.column.getName()), this.expression, this.scriptExpression, new ArrayList<String>(this.originalColumnNames));
    }

    public Column getColumn() {
        return this.column;
    }

    public String getColumnName() {
        return this.column.getName();
    }

    public DataType getDataType() {
        return this.column.getType();
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public List<String> getOriginalColumnNames() {
        return this.originalColumnNames;
    }

    public void setTransformExpressionKey(TransformExpressionKey transformExpressionKey) {
        this.transformExpressionKey = transformExpressionKey;
    }

    public boolean isValidTransformedProjectionColumn() {
        return !StringUtils.isNullOrWhitespaceOnly((String)this.scriptExpression);
    }

    public static ProjectionColumn ofForwarded(Column column) {
        String name = column.getName();
        return new ProjectionColumn(column, name, name, Collections.singletonList(name));
    }

    public static ProjectionColumn ofAliased(Column column, String newName) {
        String originalName = column.getName();
        return new ProjectionColumn(column.copy(newName), originalName, originalName, Collections.singletonList(originalName));
    }

    public static ProjectionColumn ofCalculated(String columnName, DataType dataType, String expression, String scriptExpression, List<String> originalColumnNames) {
        return new ProjectionColumn((Column)Column.physicalColumn((String)columnName, (DataType)dataType), expression, scriptExpression, originalColumnNames);
    }

    public String toString() {
        return "ProjectionColumn{column=" + this.column + ", expression='" + this.expression + '\'' + ", scriptExpression='" + this.scriptExpression + '\'' + ", originalColumnNames=" + this.originalColumnNames + ", transformExpressionKey=" + this.transformExpressionKey + '}';
    }
}

