/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data.binary;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.binary.BinaryRecordData;
import org.apache.flink.cdc.common.data.binary.BinarySegmentUtils;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentWritable;

@Internal
public class BinaryRecordDataSerializer
extends TypeSerializerSingleton<BinaryRecordData> {
    private static final long serialVersionUID = 1L;
    public static final BinaryRecordDataSerializer INSTANCE = new BinaryRecordDataSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public BinaryRecordData createInstance() {
        return new BinaryRecordData(1);
    }

    public BinaryRecordData copy(BinaryRecordData from) {
        return this.copy(from, new BinaryRecordData(from.getArity()));
    }

    public BinaryRecordData copy(BinaryRecordData from, BinaryRecordData reuse) {
        return from.copy(reuse);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryRecordData record, DataOutputView target) throws IOException {
        target.writeInt(record.getArity());
        target.writeInt(record.getSizeInBytes());
        if (target instanceof MemorySegmentWritable) {
            BinaryRecordDataSerializer.serializeWithoutLength(record, (MemorySegmentWritable)target);
        } else {
            BinarySegmentUtils.copyToView((MemorySegment[])record.getSegments(), (int)record.getOffset(), (int)record.getSizeInBytes(), (DataOutputView)target);
        }
    }

    public BinaryRecordData deserialize(DataInputView source) throws IOException {
        BinaryRecordData row = new BinaryRecordData(source.readInt());
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        row.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, length);
        return row;
    }

    public BinaryRecordData deserialize(BinaryRecordData reuse, DataInputView source) throws IOException {
        MemorySegment[] segments = reuse.getSegments();
        Preconditions.checkArgument((segments == null || segments.length == 1 && reuse.getOffset() == 0 ? 1 : 0) != 0, (String)"Reuse BinaryRecordData should have no segments or only one segment and offset start at 0.", (Object[])new Object[0]);
        int arity = source.readInt();
        int length = source.readInt();
        if (segments == null || segments[0].size() < length) {
            segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[length])};
        }
        source.readFully(segments[0].getArray(), 0, length);
        reuse.pointTo(segments, 0, length);
        return reuse;
    }

    private static void serializeWithoutLength(BinaryRecordData record, MemorySegmentWritable writable) throws IOException {
        if (record.getSegments().length == 1) {
            writable.write(record.getSegments()[0], record.getOffset(), record.getSizeInBytes());
        } else {
            BinaryRecordDataSerializer.serializeWithoutLengthSlow(record, writable);
        }
    }

    public static void serializeWithoutLengthSlow(BinaryRecordData record, MemorySegmentWritable out) throws IOException {
        int remainSize = record.getSizeInBytes();
        int posInSegOfRecord = record.getOffset();
        int segmentSize = record.getSegments()[0].size();
        for (MemorySegment segOfRecord : record.getSegments()) {
            int nWrite = Math.min(segmentSize - posInSegOfRecord, remainSize);
            assert (nWrite > 0);
            out.write(segOfRecord, posInSegOfRecord, nWrite);
            posInSegOfRecord = 0;
            if ((remainSize -= nWrite) == 0) break;
        }
        Preconditions.checkArgument((remainSize == 0 ? 1 : 0) != 0);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public TypeSerializerSnapshot<BinaryRecordData> snapshotConfiguration() {
        return new BinaryRecordDataSerializerSnapshot();
    }

    public static final class BinaryRecordDataSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<BinaryRecordData> {
        public BinaryRecordDataSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

