/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class BooleanSerializer
extends TypeSerializerSingleton<Boolean> {
    private static final long serialVersionUID = 1L;
    public static final BooleanSerializer INSTANCE = new BooleanSerializer();
    private static final Boolean FALSE = Boolean.FALSE;

    public boolean isImmutableType() {
        return true;
    }

    public Boolean createInstance() {
        return FALSE;
    }

    public Boolean copy(Boolean from) {
        return from;
    }

    public Boolean copy(Boolean from, Boolean reuse) {
        return from;
    }

    public int getLength() {
        return 1;
    }

    public void serialize(Boolean record, DataOutputView target) throws IOException {
        target.writeBoolean(record.booleanValue());
    }

    public Boolean deserialize(DataInputView source) throws IOException {
        return source.readBoolean();
    }

    public Boolean deserialize(Boolean reuse, DataInputView source) throws IOException {
        return source.readBoolean();
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeBoolean(source.readBoolean());
    }

    public TypeSerializerSnapshot<Boolean> snapshotConfiguration() {
        return new BooleanSerializerSnapshot();
    }

    public static final class BooleanSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Boolean> {
        public BooleanSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

