/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class TransformTable
extends AbstractTable {
    private String name;
    private List<Column> columns;

    public TransformTable(String name, List<Column> columns) {
        this.name = name;
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (Column column : this.columns) {
            names.add(column.getName());
            RelDataType sqlType = relDataTypeFactory.createSqlType(DataTypeConverter.convertCalciteType(column.getType()));
            types.add(sqlType);
        }
        return relDataTypeFactory.createStructType(Pair.zip(names, types));
    }
}

