/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class IntSerializer
extends TypeSerializerSingleton<Integer> {
    private static final long serialVersionUID = 1L;
    public static final IntSerializer INSTANCE = new IntSerializer();
    private static final Integer ZERO = 0;

    public boolean isImmutableType() {
        return true;
    }

    public Integer createInstance() {
        return ZERO;
    }

    public Integer copy(Integer from) {
        return from;
    }

    public Integer copy(Integer from, Integer reuse) {
        return from;
    }

    public int getLength() {
        return 4;
    }

    public void serialize(Integer record, DataOutputView target) throws IOException {
        target.writeInt(record.intValue());
    }

    public Integer deserialize(DataInputView source) throws IOException {
        return source.readInt();
    }

    public Integer deserialize(Integer reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
    }

    public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
        return new IntSerializerSnapshot();
    }

    public static final class IntSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Integer> {
        public IntSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

