/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.debezium.table;

import java.util.Map;
import java.util.Properties;

public class DebeziumOptions {
    public static final String DEBEZIUM_OPTIONS_PREFIX = "debezium.";

    public static Properties getDebeziumProperties(Map<String, String> properties) {
        Properties debeziumProperties = new Properties();
        if (DebeziumOptions.hasDebeziumProperties(properties)) {
            properties.keySet().stream().filter(key -> key.startsWith(DEBEZIUM_OPTIONS_PREFIX)).forEach(key -> {
                String value = (String)properties.get(key);
                String subKey = key.substring(DEBEZIUM_OPTIONS_PREFIX.length());
                debeziumProperties.put(subKey, value);
            });
        }
        if (properties.containsKey("table.include.list") || properties.containsKey("table.exclude.list")) {
            throw new IllegalArgumentException("table.include.list and table.exclude.list are not supported to set manually, please remove these options.");
        }
        return debeziumProperties;
    }

    private static boolean hasDebeziumProperties(Map<String, String> debeziumOptions) {
        return debeziumOptions.keySet().stream().anyMatch(k -> k.startsWith(DEBEZIUM_OPTIONS_PREFIX));
    }
}

