/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.utils;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.ZonedTimestampType;

public class PostgresTypeUtils {
    public static DataType fromDbzColumn(Column column, PostgresConnectorConfig dbzConfig, TypeRegistry typeRegistry) {
        DataType dataType = PostgresTypeUtils.convertFromColumn(column, dbzConfig, typeRegistry);
        if (column.isOptional()) {
            return dataType;
        }
        return dataType.notNull();
    }

    private static DataType convertFromColumn(Column column, PostgresConnectorConfig dbzConfig, TypeRegistry typeRegistry) {
        int nativeType = column.nativeType();
        int precision = column.length();
        int scale = column.scale().orElse(0);
        PostgresConnectorConfig.IntervalHandlingMode intervalHandlingMode = PostgresConnectorConfig.IntervalHandlingMode.parse(dbzConfig.getConfig().getString(PostgresConnectorConfig.INTERVAL_HANDLING_MODE));
        CommonConnectorConfig.BinaryHandlingMode binaryHandlingMode = dbzConfig.binaryHandlingMode();
        TemporalPrecisionMode temporalPrecisionMode = dbzConfig.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = dbzConfig.getDecimalMode() != null ? dbzConfig.getDecimalMode() : JdbcValueConverters.DecimalMode.PRECISE;
        PostgresConnectorConfig.HStoreHandlingMode hStoreHandlingMode = PostgresConnectorConfig.HStoreHandlingMode.parse(dbzConfig.getConfig().getString(PostgresConnectorConfig.HSTORE_HANDLING_MODE));
        switch (nativeType) {
            case 16: {
                return DataTypes.BOOLEAN();
            }
            case 1560: 
            case 1562: {
                if (precision == 1) {
                    return DataTypes.BOOLEAN();
                }
                return DataTypes.BINARY((int)precision);
            }
            case 1000: {
                return DataTypes.ARRAY((DataType)DataTypes.BOOLEAN());
            }
            case 17: {
                return PostgresTypeUtils.handleBinaryWithBinaryMode(binaryHandlingMode);
            }
            case 1001: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleBinaryWithBinaryMode(binaryHandlingMode));
            }
            case 21: {
                return DataTypes.SMALLINT();
            }
            case 1005: {
                return DataTypes.ARRAY((DataType)DataTypes.SMALLINT());
            }
            case 23: {
                return DataTypes.INT();
            }
            case 1007: {
                return DataTypes.ARRAY((DataType)DataTypes.INT());
            }
            case 20: 
            case 26: {
                return DataTypes.BIGINT();
            }
            case 1186: {
                return PostgresTypeUtils.handleIntervalWithIntervalHandlingMode(intervalHandlingMode);
            }
            case 1187: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleIntervalWithIntervalHandlingMode(intervalHandlingMode));
            }
            case 1016: {
                return DataTypes.ARRAY((DataType)DataTypes.BIGINT());
            }
            case 700: {
                return DataTypes.FLOAT();
            }
            case 1021: {
                return DataTypes.ARRAY((DataType)DataTypes.FLOAT());
            }
            case 701: {
                return DataTypes.DOUBLE();
            }
            case 1022: {
                return DataTypes.ARRAY((DataType)DataTypes.DOUBLE());
            }
            case 1700: {
                return PostgresTypeUtils.handleNumericWithDecimalMode(precision, scale, decimalMode);
            }
            case 1231: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleNumericWithDecimalMode(precision, scale, decimalMode));
            }
            case 790: {
                return PostgresTypeUtils.handleMoneyWithDecimalMode(dbzConfig.getConfig().getInteger(PostgresConnectorConfig.MONEY_FRACTION_DIGITS), decimalMode);
            }
            case 18: 
            case 1042: {
                return DataTypes.CHAR((int)precision);
            }
            case 1002: 
            case 1014: {
                return DataTypes.ARRAY((DataType)DataTypes.CHAR((int)precision));
            }
            case 1043: {
                return DataTypes.VARCHAR((int)precision);
            }
            case 1015: {
                return DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)precision));
            }
            case 25: 
            case 114: 
            case 142: 
            case 600: 
            case 650: 
            case 774: 
            case 829: 
            case 869: 
            case 2950: 
            case 3802: 
            case 3904: 
            case 3906: 
            case 3908: 
            case 3910: 
            case 3912: 
            case 3926: {
                return DataTypes.STRING();
            }
            case 1009: {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
            case 1114: {
                return PostgresTypeUtils.handleTimestampWithTemporalMode(temporalPrecisionMode, scale);
            }
            case 1115: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleTimestampWithTemporalMode(temporalPrecisionMode, scale));
            }
            case 1184: {
                return new ZonedTimestampType(scale);
            }
            case 1185: {
                return DataTypes.ARRAY((DataType)new ZonedTimestampType(scale));
            }
            case 1083: {
                return PostgresTypeUtils.handleTimeWithTemporalMode(temporalPrecisionMode, scale);
            }
            case 1183: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleTimeWithTemporalMode(temporalPrecisionMode, scale));
            }
            case 1082: {
                return PostgresTypeUtils.handleDateWithTemporalMode(temporalPrecisionMode);
            }
            case 1182: {
                return DataTypes.ARRAY((DataType)PostgresTypeUtils.handleDateWithTemporalMode(temporalPrecisionMode));
            }
        }
        if (nativeType == typeRegistry.ltreeOid()) {
            return DataTypes.STRING();
        }
        if (nativeType == typeRegistry.geometryOid()) {
            return DataTypes.STRING();
        }
        if (nativeType == typeRegistry.geographyOid()) {
            return DataTypes.STRING();
        }
        if (nativeType == typeRegistry.citextOid()) {
            return DataTypes.STRING();
        }
        if (nativeType == typeRegistry.hstoreOid()) {
            return PostgresTypeUtils.handleHstoreWithHstoreMode(hStoreHandlingMode);
        }
        if (nativeType == typeRegistry.ltreeArrayOid()) {
            return DataTypes.ARRAY((DataType)DataTypes.STRING());
        }
        if (nativeType == typeRegistry.geometryArrayOid()) {
            return DataTypes.ARRAY((DataType)DataTypes.STRING());
        }
        PostgresType resolvedType = typeRegistry.get(nativeType);
        if (resolvedType.isEnumType()) {
            return DataTypes.STRING();
        }
        throw new UnsupportedOperationException(String.format("Doesn't support Postgres type '%s', Postgres oid '%d' yet", column.typeName(), column.nativeType()));
    }

    public static DataType handleNumericWithDecimalMode(int precision, int scale, JdbcValueConverters.DecimalMode mode) {
        switch (mode) {
            case PRECISE: {
                if (precision > 0 && precision <= 38) {
                    return DataTypes.DECIMAL((int)precision, (int)scale);
                }
                return DataTypes.DECIMAL((int)38, (int)0);
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case STRING: {
                return DataTypes.STRING();
            }
        }
        throw new IllegalArgumentException("Unknown decimal mode: " + (Object)((Object)mode));
    }

    public static DataType handleBinaryWithBinaryMode(CommonConnectorConfig.BinaryHandlingMode mode) {
        switch (mode) {
            case BYTES: {
                return DataTypes.BYTES();
            }
            case BASE64: 
            case HEX: {
                return DataTypes.STRING();
            }
        }
        throw new IllegalArgumentException("Unknown binary mode: " + mode);
    }

    public static DataType handleMoneyWithDecimalMode(int moneyFractionDigits, JdbcValueConverters.DecimalMode mode) {
        switch (mode) {
            case PRECISE: {
                return DataTypes.DECIMAL((int)38, (int)moneyFractionDigits);
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case STRING: {
                return DataTypes.STRING();
            }
        }
        throw new IllegalArgumentException("Unknown decimal mode: " + (Object)((Object)mode));
    }

    public static DataType handleIntervalWithIntervalHandlingMode(PostgresConnectorConfig.IntervalHandlingMode mode) {
        switch (mode) {
            case NUMERIC: {
                return DataTypes.BIGINT();
            }
            case STRING: {
                return DataTypes.STRING();
            }
        }
        throw new IllegalArgumentException("Unknown interval mode: " + mode);
    }

    public static DataType handleDateWithTemporalMode(TemporalPrecisionMode mode) {
        switch (mode) {
            case ADAPTIVE: 
            case ADAPTIVE_TIME_MICROSECONDS: 
            case CONNECT: {
                return DataTypes.DATE();
            }
        }
        throw new IllegalArgumentException("Unknown temporal precision mode: " + mode);
    }

    public static DataType handleTimeWithTemporalMode(TemporalPrecisionMode mode, int scale) {
        switch (mode) {
            case ADAPTIVE: 
            case ADAPTIVE_TIME_MICROSECONDS: 
            case CONNECT: {
                return DataTypes.TIME((int)scale);
            }
        }
        throw new IllegalArgumentException("Unknown temporal precision mode: " + mode);
    }

    public static DataType handleTimestampWithTemporalMode(TemporalPrecisionMode mode, int scale) {
        switch (mode) {
            case ADAPTIVE: 
            case ADAPTIVE_TIME_MICROSECONDS: 
            case CONNECT: {
                return DataTypes.TIMESTAMP((int)scale);
            }
        }
        throw new IllegalArgumentException("Unknown temporal precision mode: " + mode);
    }

    public static DataType handleHstoreWithHstoreMode(PostgresConnectorConfig.HStoreHandlingMode mode) {
        switch (mode) {
            case JSON: {
                return DataTypes.STRING();
            }
            case MAP: {
                return DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING());
            }
        }
        throw new IllegalArgumentException("Unknown hstore mode: " + mode);
    }
}

