/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.HTTPProxyServiceControl;
import flex.management.runtime.messaging.services.http.HTTPProxyDestinationControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.log.Log;
import flex.messaging.messages.HTTPMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.SOAPMessage;
import flex.messaging.services.AbstractService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.http.HTTPProxyDestination;
import flex.messaging.services.http.proxy.ProxyException;
import flex.messaging.util.SettingsReplaceUtil;
import flex.messaging.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class HTTPProxyService
extends AbstractService {
    public static final String LOG_CATEGORY = "Service.HTTP";
    private static final int DOT_DOT_NOT_ALLOWED = 10700;
    private static final int MULTIPLE_DOMAIN_PORT = 10701;
    private static final int DYNAMIC_NOT_CONFIGURED = 10702;
    private HTTPProxyServiceControl controller;

    public HTTPProxyService() {
        this(false);
    }

    public HTTPProxyService(boolean enableManagement) {
        super(enableManagement);
    }

    public Destination createDestination(String id) {
        HTTPProxyDestination destination = new HTTPProxyDestination();
        destination.setId(id);
        destination.setManaged(this.isManaged());
        destination.setService((Service)this);
        return destination;
    }

    public void addDestination(Destination destination) {
        HTTPProxyDestination proxyDestination = (HTTPProxyDestination)destination;
        super.addDestination((Destination)proxyDestination);
    }

    public Object serviceMessage(Message msg) {
        if (!(msg instanceof HTTPMessage)) {
            ServiceException e = new ServiceException();
            e.setMessage(10454, new Object[]{"HTTPProxy", "HTTPMessage"});
            throw e;
        }
        HTTPMessage message = (HTTPMessage)msg;
        String destination = message.getDestination();
        HTTPProxyDestination dest = (HTTPProxyDestination)((Object)this.destinations.get(destination));
        FlexRemoteCredentials remoteCredentials = FlexContext.getFlexSession().getRemoteCredentials(this.getId(), destination);
        if (remoteCredentials != null) {
            message.setRemoteUsername(remoteCredentials.getUsername());
            message.setRemotePassword((String)remoteCredentials.getCredentials());
        } else if (dest.getRemoteUsername() != null && dest.getRemotePassword() != null) {
            message.setRemoteUsername(dest.getRemoteUsername());
            message.setRemotePassword(dest.getRemotePassword());
        }
        ServiceAdapter adapter = dest.getAdapter();
        Object result = message instanceof SOAPMessage ? this.invokeSoap(adapter, (SOAPMessage)message, dest) : this.invokeHttp(adapter, message, dest);
        if (Log.isDebug()) {
            String debugResult = StringUtils.prettifyString((String)String.valueOf(result));
            Log.getLogger((String)this.getLogCategory()).debug("HTTP request: " + message + StringUtils.NEWLINE + "  response: " + StringUtils.NEWLINE + debugResult + StringUtils.NEWLINE);
        }
        return result;
    }

    protected Object invokeSoap(ServiceAdapter adapter, SOAPMessage message, HTTPProxyDestination destination) {
        HTTPProxyDestinationControl destinationControl;
        if (this.isManaged() && (destinationControl = (HTTPProxyDestinationControl)destination.getControl()) != null) {
            destinationControl.incrementInvokeSOAPCount();
        }
        String dynamicUrl = message.getUrl();
        String contextPath = null;
        String serverName = null;
        String serverPort = null;
        String protocol = null;
        HttpServletRequest req = FlexContext.getHttpRequest();
        if (req != null) {
            contextPath = req.getContextPath();
            protocol = req.getScheme();
            serverName = req.getServerName();
            int port = req.getServerPort();
            if (port != 0) {
                serverPort = Integer.valueOf(req.getServerPort()).toString();
            }
        }
        if (dynamicUrl == null || dynamicUrl.length() <= 0) {
            throw new MessageException("A SOAP endpoint was not provided.");
        }
        this.checkUrl(dynamicUrl, contextPath, destination, serverName, serverPort, protocol, message.getRemoteUsername() != null);
        return adapter.invoke((Message)message);
    }

    protected void checkUrl(String url, String contextPath, HTTPProxyDestination destination, String serverName, String serverPort, String serverProtocol, boolean authSupplied) {
        String originalUrl = url;
        String defaultUrl = destination.getParsedDefaultUrl(contextPath, serverName, serverPort, serverProtocol);
        List dynamicUrls = destination.getParsedDynamicUrls(contextPath);
        int i = url.indexOf("/..");
        while (i != -1) {
            if (i == url.length() - 3 || url.charAt(i + 3) == '/') {
                throw new ProxyException(10700);
            }
            i = url.indexOf("/..", i + 1);
        }
        url = url.toLowerCase();
        url = SettingsReplaceUtil.updateIPv6((String)url);
        if (defaultUrl != null && defaultUrl.equalsIgnoreCase(url)) {
            return;
        }
        char[] urlChars = url.toCharArray();
        for (i = 0; i < dynamicUrls.size(); ++i) {
            char[] pattern = (char[])dynamicUrls.get(i);
            boolean matches = StringUtils.findMatchWithWildcard((char[])urlChars, (char[])pattern);
            if (!matches) continue;
            if (!authSupplied || destination.allowsDynamicAuthentication()) {
                return;
            }
            throw new ProxyException(10701);
        }
        ProxyException exception = new ProxyException();
        exception.setMessage(10702, new Object[]{originalUrl, destination.getId()});
        throw exception;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected Object invokeHttp(ServiceAdapter adapter, HTTPMessage message, HTTPProxyDestination destination) {
        HTTPProxyDestinationControl destinationControl;
        if (this.isManaged() && (destinationControl = (HTTPProxyDestinationControl)destination.getControl()) != null) {
            destinationControl.incrementInvokeHTTPCount();
        }
        String dynamicUrl = message.getUrl();
        String contextPath = null;
        String serverName = null;
        String serverPort = null;
        String protocol = null;
        HttpServletRequest req = FlexContext.getHttpRequest();
        if (req != null) {
            contextPath = req.getContextPath();
            protocol = req.getScheme();
            serverName = req.getServerName();
            int port = req.getServerPort();
            if (port != 0) {
                serverPort = Integer.toString(req.getServerPort());
            }
        }
        if (dynamicUrl != null && !"".equals(dynamicUrl)) {
            this.checkUrl(dynamicUrl, contextPath, destination, serverName, serverPort, protocol, message.getRemoteUsername() != null);
        } else {
            String url = destination.getParsedDefaultUrl(contextPath, serverName, serverPort, protocol);
            message.setUrl(url);
        }
        return adapter.invoke((Message)message);
    }

    protected void setupServiceControl(MessageBroker broker) {
        this.controller = new HTTPProxyServiceControl(this, broker.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }
}

