/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.legacy;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Closeable;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletResponseWrapper;
import org.apache.felix.http.javaxwrappers.ServletWrapper;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.WebConsoleSecurityProvider3;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.legacy.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.servlet.BasicWebConsoleSecurityProvider;
import org.apache.felix.webconsole.internal.servlet.Plugin;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.apache.felix.webconsole.spi.SecurityProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LegacyServicesTracker
implements Closeable,
ServiceTrackerCustomizer<Servlet, LegacyServletPlugin> {
    private final ServiceTracker<Servlet, LegacyServletPlugin> servletTracker;
    private final PluginHolder pluginHolder;
    private final LegacySecurityProviderTracker securityProviderTracker;

    public LegacyServicesTracker(PluginHolder pluginHolder, BundleContext context) {
        new ServletWrapper(null);
        this.pluginHolder = pluginHolder;
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=" + Servlet.class.getName() + ")(felix.webconsole.label=*))");
        }
        catch (InvalidSyntaxException e) {
            throw new InternalError("Failed creating filter: " + e.getMessage());
        }
        this.servletTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)this);
        this.servletTracker.open();
        this.securityProviderTracker = new LegacySecurityProviderTracker(context);
    }

    @Override
    public void close() {
        this.servletTracker.close();
        this.securityProviderTracker.close();
    }

    public LegacyServletPlugin addingService(ServiceReference<Servlet> reference) {
        String label = Util.getStringProperty(reference, "felix.webconsole.label");
        if (label != null) {
            Util.LOGGER.warn("Legacy webconsole plugin found. Update this to the Jakarta Servlet API: {}", (Object)Util.toString(reference));
            LegacyServletPlugin plugin = new LegacyServletPlugin(this.pluginHolder, reference, label);
            this.pluginHolder.addPlugin(plugin);
            return plugin;
        }
        return null;
    }

    public void modifiedService(ServiceReference<Servlet> reference, LegacyServletPlugin service) {
        this.removedService(reference, service);
        this.addingService((ServiceReference)reference);
    }

    public void removedService(ServiceReference<Servlet> reference, LegacyServletPlugin service) {
        this.pluginHolder.removePlugin(service);
    }

    public static class SecurityProviderWrapper
    implements SecurityProvider {
        private final WebConsoleSecurityProvider provider;

        public SecurityProviderWrapper(WebConsoleSecurityProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object authenticate(HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) {
            if (this.provider instanceof WebConsoleSecurityProvider2 && ((WebConsoleSecurityProvider2)this.provider).authenticate((javax.servlet.http.HttpServletRequest)new HttpServletRequestWrapper(request), (HttpServletResponse)new HttpServletResponseWrapper(response))) {
                return request.getAttribute("org.apache.felix.webconsole.user");
            }
            return null;
        }

        @Override
        public boolean authorize(Object user, String role) {
            return this.provider.authorize(user, role);
        }

        @Override
        public void logout(HttpServletRequest request, jakarta.servlet.http.HttpServletResponse response) {
            if (this.provider instanceof WebConsoleSecurityProvider3) {
                ((WebConsoleSecurityProvider3)this.provider).logout((javax.servlet.http.HttpServletRequest)new HttpServletRequestWrapper(request), (HttpServletResponse)new HttpServletResponseWrapper(response));
            }
        }
    }

    public static class LegacySecurityProviderTracker
    implements ServiceTrackerCustomizer<WebConsoleSecurityProvider, ServiceRegistration<SecurityProvider>> {
        private final ServiceTracker<WebConsoleSecurityProvider, ServiceRegistration<SecurityProvider>> tracker;
        private final BundleContext bundleContext;

        public LegacySecurityProviderTracker(BundleContext context) {
            this.bundleContext = context;
            this.tracker = new ServiceTracker(context, WebConsoleSecurityProvider.class, (ServiceTrackerCustomizer)this);
            this.tracker.open();
        }

        public void close() {
            this.tracker.close();
        }

        public ServiceRegistration<SecurityProvider> addingService(ServiceReference<WebConsoleSecurityProvider> reference) {
            Util.LOGGER.warn("Legacy webconsole plugin found. Update this to the Jakarta Servlet API: {}", (Object)Util.toString(reference));
            final WebConsoleSecurityProvider provider = (WebConsoleSecurityProvider)this.bundleContext.getService(reference);
            if (provider != null) {
                SecurityProvider wrapper = provider instanceof WebConsoleSecurityProvider2 ? new SecurityProviderWrapper(provider) : new BasicWebConsoleSecurityProvider(this.bundleContext){

                    @Override
                    public Object authenticate(String username, String password) {
                        return provider.authenticate(username, password);
                    }

                    @Override
                    public boolean authorize(Object user, String role) {
                        return provider.authorize(user, role);
                    }
                };
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                if (reference.getProperty("service.ranking") != null) {
                    ((Dictionary)props).put("service.ranking", reference.getProperty("service.ranking"));
                }
                if (reference.getProperty("webconsole.security.provider.id") != null) {
                    ((Dictionary)props).put("webconsole.security.provider.id", reference.getProperty("webconsole.security.provider.id"));
                }
                return reference.getBundle().getBundleContext().registerService(SecurityProvider.class, (Object)wrapper, props);
            }
            return null;
        }

        public void modifiedService(ServiceReference<WebConsoleSecurityProvider> reference, ServiceRegistration<SecurityProvider> service) {
        }

        public void removedService(ServiceReference<WebConsoleSecurityProvider> reference, ServiceRegistration<SecurityProvider> service) {
            this.bundleContext.ungetService(reference);
            try {
                service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static class LegacyServletPlugin
    extends Plugin {
        public LegacyServletPlugin(PluginHolder holder, ServiceReference<Servlet> serviceReference, String label) {
            super(holder, serviceReference, label);
        }

        @Override
        protected jakarta.servlet.Servlet doGetConsolePlugin() {
            Object servlet = (Servlet)this.getHolder().getBundleContext().getService(this.getServiceReference());
            if (servlet != null) {
                if (servlet instanceof AbstractWebConsolePlugin) {
                    if (this.title == null) {
                        this.title = ((AbstractWebConsolePlugin)((Object)servlet)).getTitle();
                    }
                    if (this.category == null) {
                        this.category = ((AbstractWebConsolePlugin)((Object)servlet)).getCategory();
                    }
                } else {
                    servlet = new WebConsolePluginAdapter(this.getLabel(), (Servlet)servlet, (ServiceReference<Servlet>)this.getServiceReference());
                }
                return new org.apache.felix.http.jakartawrappers.ServletWrapper(servlet);
            }
            return null;
        }
    }
}

