/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.felix.webconsole.spi.ConfigurationHandler;
import org.apache.felix.webconsole.spi.ValidationException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationUtil {
    private static final String PLACEHOLDER_PID = "__Temporary PID replaced by real PID upon save__";

    public static Configuration findConfiguration(ConfigurationAdmin service, String pid) {
        if (pid != null) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] configs = service.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (IOException | InvalidSyntaxException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Configuration getOrCreateConfiguration(ConfigurationAdmin service, List<ConfigurationHandler> handlers, String pid, String factoryPid) throws ValidationException, IOException {
        Configuration cfg = null;
        if (!PLACEHOLDER_PID.equals(pid)) {
            cfg = ConfigurationUtil.findConfiguration(service, pid);
        }
        if (cfg == null) {
            if (factoryPid != null) {
                for (ConfigurationHandler handler : handlers) {
                    handler.createFactoryConfiguration(factoryPid, null);
                }
                cfg = service.createFactoryConfiguration(factoryPid, null);
            } else {
                for (ConfigurationHandler handler : handlers) {
                    handler.createConfiguration(pid);
                }
                cfg = service.getConfiguration(pid, null);
            }
        }
        return cfg;
    }

    public static final boolean isAllowedPid(String pid) {
        for (int i = 0; i < pid.length(); ++i) {
            char c = pid.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"' && c != '\'') continue;
            return false;
        }
        return true;
    }

    public static Configuration getPlaceholderConfiguration(String factoryPid) {
        return new PlaceholderConfiguration(factoryPid);
    }

    public static String getPlaceholderPid() {
        return PLACEHOLDER_PID;
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return ConfigurationUtil.PLACEHOLDER_PID;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary<String, Object> getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary<String, ?> properties) {
        }

        public void delete() {
        }

        public long getChangeCount() {
            return 0L;
        }

        public void addAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        }

        public Set<Configuration.ConfigurationAttribute> getAttributes() {
            return Collections.emptySet();
        }

        public Dictionary<String, Object> getProcessedProperties(ServiceReference<?> reference) {
            return null;
        }

        public void removeAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        }

        public boolean updateIfDifferent(Dictionary<String, ?> properties) throws IOException {
            return false;
        }
    }
}

