/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public abstract class Plugin
implements ServletConfig,
Comparable<Plugin> {
    private final PluginHolder holder;
    private final String label;
    private final ServiceReference<Servlet> serviceReference;
    protected volatile String title;
    protected volatile String category;
    private volatile AbstractWebConsolePlugin consolePlugin;

    public Plugin(PluginHolder holder, ServiceReference<Servlet> serviceReference, String label) {
        this.holder = holder;
        this.serviceReference = serviceReference;
        this.label = label;
    }

    public ServiceReference<Servlet> getServiceReference() {
        return this.serviceReference;
    }

    public Bundle getBundle() {
        if (this.serviceReference != null) {
            return this.serviceReference.getBundle();
        }
        return this.holder.getBundleContext().getBundle();
    }

    public boolean init() {
        AbstractWebConsolePlugin plugin = this.doGetConsolePlugin();
        if (plugin != null) {
            try {
                plugin.init(this);
            }
            catch (ServletException servletException) {
                // empty catch block
            }
            this.consolePlugin = plugin;
        }
        return this.getConsolePlugin() != null;
    }

    public void dispose() {
        if (this.consolePlugin != null) {
            try {
                this.consolePlugin.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.doUngetConsolePlugin(this.consolePlugin);
            this.consolePlugin = null;
        }
    }

    private static Integer getRanking(ServiceReference<Servlet> serviceReference) {
        Object ranking;
        Object object = ranking = serviceReference != null ? serviceReference.getProperty("service.ranking") : null;
        if (ranking instanceof Integer) {
            return (Integer)ranking;
        }
        return 0;
    }

    @Override
    public int compareTo(Plugin other) {
        int result = this.getLabel().compareTo(other.getLabel());
        if (result == 0) {
            Integer otherRank;
            Integer rank;
            Long id = this.serviceReference != null ? (Long)this.serviceReference.getProperty("service.id") : 0L;
            Long otherId = other.serviceReference != null ? (Long)other.serviceReference.getProperty("service.id") : 0L;
            result = id.compareTo(otherId);
            if (result != 0 && (result = (rank = Plugin.getRanking(this.serviceReference)).compareTo(otherRank = Plugin.getRanking(other.serviceReference))) == 0) {
                result = -1 * id.compareTo(otherId);
            }
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    protected PluginHolder getHolder() {
        return this.holder;
    }

    public String getTitle() {
        return this.title != null ? this.title : this.getLabel();
    }

    public String getCategory() {
        return this.category;
    }

    public AbstractWebConsolePlugin getConsolePlugin() {
        return this.consolePlugin;
    }

    protected boolean isEnabled() {
        return true;
    }

    public abstract String getId();

    protected abstract AbstractWebConsolePlugin doGetConsolePlugin();

    protected abstract void doUngetConsolePlugin(AbstractWebConsolePlugin var1);

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.emptyEnumeration();
    }

    public ServletContext getServletContext() {
        return this.getHolder().getServletContext();
    }

    public String getServletName() {
        return this.getTitle();
    }

    public static class InternalPlugin
    extends Plugin {
        private final String pluginClassName;
        private final OsgiManager osgiManager;
        private volatile boolean doLog = true;

        public InternalPlugin(PluginHolder holder, OsgiManager osgiManager, String pluginClassName, String label) {
            super(holder, null, label);
            this.osgiManager = osgiManager;
            this.pluginClassName = pluginClassName;
        }

        @Override
        public String getId() {
            return this.pluginClassName;
        }

        @Override
        protected final boolean isEnabled() {
            return !this.osgiManager.isPluginDisabled(this.pluginClassName);
        }

        @Override
        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            AbstractWebConsolePlugin plugin;
            block5: {
                if (!this.isEnabled()) {
                    if (this.doLog) {
                        this.osgiManager.log(3, "Ignoring plugin " + this.pluginClassName + ": Disabled by configuration");
                        this.doLog = false;
                    }
                    return null;
                }
                plugin = null;
                try {
                    Class<?> pluginClass = this.getClass().getClassLoader().loadClass(this.pluginClassName);
                    plugin = (AbstractWebConsolePlugin)((Object)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    if (plugin instanceof OsgiManagerPlugin) {
                        ((OsgiManagerPlugin)((Object)plugin)).activate(this.osgiManager.getBundleContext());
                    }
                    this.title = plugin.getTitle();
                    this.category = plugin.getCategory();
                    this.doLog = true;
                }
                catch (Throwable t) {
                    plugin = null;
                    if (!this.doLog) break block5;
                    this.osgiManager.log(2, "Failed to instantiate plugin " + this.pluginClassName, t);
                    this.doLog = false;
                }
            }
            return plugin;
        }

        @Override
        protected void doUngetConsolePlugin(AbstractWebConsolePlugin plugin) {
            if (plugin instanceof OsgiManagerPlugin) {
                ((OsgiManagerPlugin)((Object)plugin)).deactivate();
            }
        }
    }

    public static class ServletPlugin
    extends Plugin {
        public ServletPlugin(PluginHolder holder, ServiceReference<Servlet> serviceReference, String label) {
            super(holder, serviceReference, label);
        }

        @Override
        public String getId() {
            return this.getServiceReference().toString();
        }

        protected Servlet getService() {
            return (Servlet)this.getHolder().getBundleContext().getService(this.getServiceReference());
        }

        @Override
        protected AbstractWebConsolePlugin doGetConsolePlugin() {
            Servlet service = this.getService();
            if (service != null) {
                AbstractWebConsolePlugin servlet;
                this.title = Util.getStringProperty(this.getServiceReference(), "felix.webconsole.title");
                this.category = Util.getStringProperty(this.getServiceReference(), "felix.webconsole.category");
                if (service instanceof AbstractWebConsolePlugin) {
                    servlet = (AbstractWebConsolePlugin)service;
                    if (this.title == null) {
                        this.title = servlet.getTitle();
                    }
                    if (this.category == null) {
                        this.category = servlet.getCategory();
                    }
                } else {
                    servlet = new WebConsolePluginAdapter(this.getLabel(), service, this.getServiceReference());
                }
                return servlet;
            }
            return null;
        }

        @Override
        protected void doUngetConsolePlugin(AbstractWebConsolePlugin consolePlugin) {
            try {
                this.getHolder().getBundleContext().ungetService(this.getServiceReference());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public String getInitParameter(String name) {
            Object property = this.getServiceReference().getProperty(name);
            if (property != null && !property.getClass().isArray()) {
                return property.toString();
            }
            return super.getInitParameter(name);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            final String[] keys = this.getServiceReference().getPropertyKeys();
            return new Enumeration<String>(){
                int idx = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.idx < keys.length;
                }

                @Override
                public String nextElement() {
                    if (this.hasMoreElements()) {
                        return keys[this.idx++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    }
}

