/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.PrintWriter;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class PreferencesConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Preferences";

    @Override
    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printConfiguration(PrintWriter printWriter) {
        ServiceReference sr = this.getBundleContext().getServiceReference(PreferencesService.class.getName());
        if (sr == null) {
            printWriter.println("Status: Preferences Service not available");
        } else {
            PreferencesService ps = (PreferencesService)this.getBundleContext().getService(sr);
            try {
                PreferencesConfigurationPrinter.printPreferences(printWriter, ps.getSystemPreferences());
                String[] users = ps.getUsers();
                for (int i = 0; users != null && i < users.length; ++i) {
                    printWriter.println("*** User Preferences " + users[i] + ":");
                    PreferencesConfigurationPrinter.printPreferences(printWriter, ps.getUserPreferences(users[i]));
                }
            }
            catch (BackingStoreException backingStoreException) {
            }
            finally {
                this.getBundleContext().ungetService(sr);
            }
        }
    }

    private static final void printPreferences(PrintWriter pw, Preferences prefs) throws BackingStoreException {
        String[] children = prefs.childrenNames();
        String[] keys = prefs.keys();
        if (children.length == 0 && keys.length == 0) {
            pw.println("Status: No Preferences available");
        } else {
            int i;
            for (i = 0; i < children.length; ++i) {
                PreferencesConfigurationPrinter.printPreferences(pw, prefs.node(children[i]));
            }
            for (i = 0; i < keys.length; ++i) {
                ConfigurationRender.infoLine(pw, null, prefs.absolutePath() + "/" + keys[i], prefs.get(keys[i], null));
            }
        }
        pw.println();
    }
}

