/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.compendium.ConfigManagerBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigManager
extends ConfigManagerBase {
    private static final String LABEL = "configMgr";
    private static final String TITLE = "%configMgr.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/config.css"};
    private static final String PID_FILTER = "pidFilter";
    private static final String PID = "pid";
    private static final String factoryPID = "factoryPid";
    private static final String PLACEHOLDER_PID = "[Temporary PID replaced by real PID upon save]";
    private static final int ATTRIBUTE_TYPE_PASSWORD = 12;
    private static final String PASSWORD_PLACEHOLDER_VALUE = "unmodified";
    private final String TEMPLATE = this.readTemplateFile("/templates/config.html");
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;

    public ConfigManager() {
        super(LABEL, TITLE, CSS);
    }

    private boolean isAllowedPid(String pid) {
        for (int i = 0; i < pid.length(); ++i) {
            char c = pid.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"' && c != '\'') continue;
            return false;
        }
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getParameter(PID);
        if (pid == null) {
            String info = request.getPathInfo();
            pid = WebConsoleUtil.urlDecode(info.substring(info.lastIndexOf(47) + 1));
        }
        String pidFilter = request.getParameter(PID_FILTER);
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (pid == null || pid.length() == 0 || ca == null) {
            return;
        }
        if (!this.isAllowedPid(pid)) {
            response.sendError(500);
            return;
        }
        if (pidFilter != null && !this.isAllowedPid(pidFilter)) {
            response.sendError(500);
            return;
        }
        PlaceholderConfiguration config = null;
        if (request.getParameter("create") != null) {
            config = new PlaceholderConfiguration(pid);
            pid = config.getPid();
        } else if (request.getParameter("apply") != null) {
            String redirect = this.applyConfiguration(request, ca, pid);
            if (redirect != null) {
                if (pidFilter != null) {
                    redirect = redirect + "?pidFilter=" + pidFilter;
                }
                WebConsoleUtil.sendRedirect(request, response, redirect);
            } else {
                response.setContentType("text/plain");
                response.getWriter().print("true");
            }
            return;
        }
        if (config == null) {
            config = ConfigManager.getConfiguration(ca, pid);
        }
        if (request.getParameter("unbind") != null) {
            if (config != null && config.getBundleLocation() != null) {
                config.setBundleLocation(null);
                if (config.getBundleLocation() != null) {
                    config.setBundleLocation("??invalid:bundle/location");
                    config.setBundleLocation(null);
                }
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print("{ \"status\": true }");
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        this.printConfigurationJson(response.getWriter(), pid, config, pidFilter, locale);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String pid = info.substring(info.lastIndexOf(47) + 1, info.length() - 5);
            String pidFilter = request.getParameter(PID_FILTER);
            if (pidFilter == null) {
                pidFilter = pid;
            }
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
            if (pid != null && !this.isAllowedPid(pid)) {
                response.sendError(500);
            }
            if (pidFilter != null && !this.isAllowedPid(pidFilter)) {
                response.sendError(500);
            }
            ConfigurationAdmin ca = this.getConfigurationAdmin();
            Locale loc = this.getLocale(request);
            String locale = loc != null ? loc.toString() : null;
            PrintWriter pw = response.getWriter();
            try {
                pw.write("[");
                SortedMap services = this.getServices(pid, pidFilter, locale, false);
                boolean printColon = false;
                Iterator spi = services.keySet().iterator();
                while (spi.hasNext()) {
                    String servicePid = (String)spi.next();
                    Configuration config = ConfigManager.getConfiguration(ca, servicePid);
                    if (config == null) continue;
                    if (printColon) {
                        pw.print(',');
                    }
                    this.printConfigurationJson(pw, servicePid, config, pidFilter, locale);
                    printColon = true;
                }
                pw.write("]");
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getPathInfo().substring(this.getLabel().length() + 1);
        pid = pid.length() == 0 ? null : pid.substring(pid.lastIndexOf(47) + 1);
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter == null) {
            pidFilter = pid;
        }
        if (pidFilter != null) {
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
        }
        if (pid != null && !this.isAllowedPid(pid)) {
            response.sendError(500);
        }
        if (pidFilter != null && !this.isAllowedPid(pidFilter)) {
            response.sendError(500);
        }
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)(ca != null ? Boolean.TRUE : Boolean.FALSE));
            if (ca != null) {
                this.listConfigurations(json, ca, pidFilter, locale, loc);
                this.listFactoryConfigurations(json, pidFilter, locale);
            }
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
        if (request.getParameter("create") != null && pid != null) {
            pid = new PlaceholderConfiguration(pid).getPid();
        }
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", json.toString());
        vars.put("selectedPid", pid != null ? pid : "");
        response.getWriter().print(this.TEMPLATE);
    }

    private static final Configuration getConfiguration(ConfigurationAdmin ca, String pid) {
        if (ca != null && pid != null) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private final void listFactoryConfigurations(JSONObject json, String pidFilter, String locale) {
        try {
            SortedMap optionsFactory = this.getServices((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsFactory, this.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            Iterator ii = optionsFactory.keySet().iterator();
            while (ii.hasNext()) {
                String id = (String)ii.next();
                Object name = optionsFactory.get(id);
                json.append("fpids", (Object)new JSONObject().put("id", (Object)id).put("name", name));
            }
        }
        catch (Exception e) {
            this.log("listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    private final void listConfigurations(JSONObject json, ConfigurationAdmin ca, String pidFilter, String locale, Locale loc) {
        try {
            SortedMap optionsPlain = this.getServices((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsPlain, this.getPidObjectClasses(locale), pidFilter, "service.pid");
            Configuration[] cfgs = ca.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid) || !this.isAllowedPid(pid)) continue;
                ObjectClassDefinition ocd = null;
                try {
                    ocd = this.getObjectClassDefinition(cfgs[i], locale);
                }
                catch (IllegalArgumentException t) {
                    // empty catch block
                }
                if (ocd != null) {
                    optionsPlain.put(pid, ocd.getName());
                    continue;
                }
                optionsPlain.put(pid, pid);
            }
            Iterator ii = optionsPlain.keySet().iterator();
            while (ii.hasNext()) {
                String id = (String)ii.next();
                Object name = optionsPlain.get(id);
                Configuration config = ConfigManager.getConfiguration(ca, id);
                JSONObject data = new JSONObject().put("id", (Object)id).put("name", name);
                if (null != config) {
                    Bundle bundle;
                    String fpid = config.getFactoryPid();
                    if (null != fpid) {
                        data.put("fpid", (Object)fpid);
                    }
                    if (null != (bundle = this.getBoundBundle(config))) {
                        data.put("bundle", bundle.getBundleId());
                        data.put("bundle_name", (Object)Util.getName(bundle, loc));
                    }
                }
                json.append("pids", (Object)data);
            }
        }
        catch (Exception e) {
            this.log("listConfigurations: Unexpected problem encountered", e);
        }
    }

    private final Bundle getBoundBundle(Configuration config) {
        if (null == config) {
            return null;
        }
        String location = config.getBundleLocation();
        if (null == location) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(location)) continue;
            return bundles[i];
        }
        return null;
    }

    private SortedMap getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String) || !this.isAllowedPid((String)pidObject)) continue;
            String pid = (String)pidObject;
            ObjectClassDefinition ocd = this.getObjectClassDefinition(refs[i].getBundle(), pid, locale);
            String name = ocd != null ? ocd.getName() : pid;
            if (ocdRequired && ocd == null) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map pidMap, Map ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException not_expected) {
                // empty catch block
            }
        }
        Iterator ei = ocdCollection.entrySet().iterator();
        while (ei.hasNext()) {
            Map.Entry ociEntry = ei.next();
            String pid = (String)ociEntry.getKey();
            ObjectClassDefinition ocd = (ObjectClassDefinition)ociEntry.getValue();
            if (filter == null) {
                pidMap.put(pid, ocd.getName());
                continue;
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (!filter.match(props)) continue;
            pidMap.put(pid, ocd.getName());
        }
    }

    private void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter((Writer)pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                this.log("Error reading configuration PID " + pid, e);
            }
        }
    }

    private void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws JSONException {
        ObjectClassDefinition ocd;
        json.key(PID);
        json.value((Object)pid);
        if (pidFilter != null) {
            json.key(PID_FILTER);
            json.value((Object)pidFilter);
        }
        Hashtable props = null;
        if (config != null) {
            props = config.getProperties();
            ocd = this.getObjectClassDefinition(config, locale);
        } else {
            ocd = this.getObjectClassDefinition(pid, locale);
        }
        if (props == null) {
            props = new Hashtable();
        }
        if (ocd != null) {
            this.mergeWithMetaType(props, ocd, json);
        } else {
            json.key("title").value((Object)pid);
            json.key("description").value((Object)"This form is automatically generated from existing properties because no property descriptors are available for this configuration. This may be cause by the absence of the OSGi Metatype Service or the absence of a MetaType descriptor for this configuration.");
            json.key("properties").object();
            Enumeration pe = ((Dictionary)props).keys();
            while (pe.hasMoreElements()) {
                String id = (String)pe.nextElement();
                if (id.equals("service.pid") || id.equals("service.description") || id.equals("service.id") || id.equals("service.vendor") || id.equals("service.bundleLocation") || id.equals("service.factoryPid")) continue;
                Object value = ((Dictionary)props).get(id);
                AttributeDefinition ad = ConfigManager.getAttributeDefinition(id, value);
                json.key(id);
                ConfigManager.attributeToJson(json, ad, value);
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    private void mergeWithMetaType(Dictionary props, ObjectClassDefinition ocd, JSONWriter json) throws JSONException {
        AttributeDefinition[] ad;
        json.key("title").value((Object)ocd.getName());
        if (ocd.getDescription() != null) {
            json.key("description").value((Object)ocd.getDescription());
        }
        if ((ad = ocd.getAttributeDefinitions(-1)) != null) {
            json.key("properties").object();
            for (int i = 0; i < ad.length; ++i) {
                AttributeDefinition adi = ad[i];
                String attrId = adi.getID();
                json.key(attrId);
                ConfigManager.attributeToJson(json, adi, props.get(attrId));
            }
            json.endObject();
        }
    }

    private void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws JSONException {
        String location;
        if (config.getFactoryPid() != null) {
            json.key(factoryPID);
            json.value((Object)config.getFactoryPid());
        }
        if (config.getBundleLocation() == null) {
            location = "";
        } else {
            Bundle bundle = this.getBundle(config.getBundleLocation());
            if (bundle == null) {
                location = config.getBundleLocation();
            } else {
                Dictionary headers = bundle.getHeaders(locale);
                String name = (String)headers.get("Bundle-Name");
                location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ")";
                Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                location = location + ", Version " + v.toString();
            }
        }
        json.key("bundleLocation");
        json.value((Object)location);
        String pid = config.getPid();
        String serviceLocation = "";
        try {
            ServiceReference[] refs = this.getBundleContext().getServiceReferences(null, "(&(objectClass=" + (class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName() + ")(" + "service.pid" + '=' + pid + "))");
            if (refs != null && refs.length > 0) {
                serviceLocation = refs[0].getBundle().getLocation();
            }
        }
        catch (Throwable t) {
            this.log("Error getting service associated with configuration " + pid, t);
        }
        json.key("bundle_location");
        json.value((Object)config.getBundleLocation());
        json.key("service_location");
        json.value((Object)serviceLocation);
    }

    private String applyConfiguration(HttpServletRequest request, ConfigurationAdmin ca, String pid) throws IOException {
        if (request.getParameter("delete") != null) {
            if (!PLACEHOLDER_PID.equals(pid)) {
                this.log("applyConfiguration: Deleting configuration " + pid);
                Configuration config = ca.getConfiguration(pid, null);
                config.delete();
            }
            return null;
        }
        String factoryPid = request.getParameter(factoryPID);
        Configuration config = null;
        String propertyList = request.getParameter("propertylist");
        if (propertyList != null) {
            config = ConfigManager.getConfiguration(ca, pid, factoryPid);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            Map adMap = this.getAttributeDefinitionMap(config, null);
            StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
            while (propTokens.hasMoreTokens()) {
                String prop;
                String propName = propTokens.nextToken();
                AttributeDefinition ad = (AttributeDefinition)adMap.get(propName);
                if (ad == null) {
                    Object currentValue = ((Dictionary)props).get(propName);
                    ad = ConfigManager.getAttributeDefinition(propName, currentValue);
                }
                int attributeType = ConfigManager.getAttributeType(ad);
                if (ad == null || ad.getCardinality() == 0 && (attributeType == 1 || attributeType == 12)) {
                    prop = request.getParameter(propName);
                    if (prop == null || attributeType == 12 && PASSWORD_PLACEHOLDER_VALUE.equals(prop)) continue;
                    ((Dictionary)props).put(propName, prop);
                    continue;
                }
                if (ad.getCardinality() == 0) {
                    prop = request.getParameter(propName);
                    if (prop == null) continue;
                    try {
                        ((Dictionary)props).put(propName, ConfigManager.toType(attributeType, prop));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                Vector<Object> vec = new Vector<Object>();
                String[] properties = request.getParameterValues(propName);
                if (properties != null) {
                    if (attributeType == 12) {
                        ConfigManager.setPasswordProps(vec, properties, ((Dictionary)props).get(propName));
                    } else {
                        for (int i = 0; i < properties.length; ++i) {
                            try {
                                vec.add(ConfigManager.toType(attributeType, properties[i]));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                    }
                }
                int maxSize = Math.abs(ad.getCardinality());
                if (vec.size() > maxSize && maxSize > 0) {
                    vec.setSize(maxSize);
                }
                if (ad.getCardinality() < 0) {
                    if (vec.isEmpty()) {
                        ((Dictionary)props).remove(propName);
                        continue;
                    }
                    ((Dictionary)props).put(propName, vec);
                    continue;
                }
                ((Dictionary)props).put(propName, ConfigManager.toArray(attributeType, vec));
            }
            config.update(props);
        }
        return config != null ? config.getPid() : "";
    }

    private static final Configuration getConfiguration(ConfigurationAdmin ca, String pid, String factoryPid) throws IOException {
        if (factoryPid != null && (pid == null || pid.equals(PLACEHOLDER_PID))) {
            return ca.createFactoryConfiguration(factoryPid, null);
        }
        return ca.getConfiguration(pid, null);
    }

    private static void attributeToJson(JSONWriter json, AttributeDefinition ad, Object propValue) throws JSONException {
        boolean isPassword;
        json.object();
        Object value = propValue != null ? propValue : (ad.getDefaultValue() != null ? ad.getDefaultValue() : (ad.getCardinality() == 0 ? "" : new String[]{}));
        json.key("name");
        json.value((Object)ad.getName());
        int propertyType = ConfigManager.getAttributeType(ad);
        json.key("type");
        if (ad.getOptionLabels() != null && ad.getOptionLabels().length > 0) {
            json.object();
            json.key("labels");
            json.value(Arrays.asList(ad.getOptionLabels()));
            json.key("values");
            json.value(Arrays.asList(ad.getOptionValues()));
            json.endObject();
        } else {
            json.value((long)propertyType);
        }
        boolean bl = isPassword = propertyType == 12;
        if (ad.getCardinality() == 0) {
            if (isPassword) {
                value = PASSWORD_PLACEHOLDER_VALUE;
            } else if (value instanceof Vector) {
                value = ((Vector)value).get(0);
            } else if (value.getClass().isArray()) {
                value = Array.get(value, 0);
            }
            json.key("value");
            json.value(value);
        } else {
            value = new JSONArray((Collection)ConfigManager.toList(value));
            if (isPassword) {
                JSONArray tmp = value;
                for (int tmpI = 0; tmpI < tmp.length(); ++tmpI) {
                    tmp.put(tmpI, (Object)PASSWORD_PLACEHOLDER_VALUE);
                }
            }
            json.key("values");
            json.value(value);
        }
        if (ad.getDescription() != null) {
            json.key("description");
            json.value((Object)(ad.getDescription() + " (" + ad.getID() + ")"));
        }
        json.endObject();
    }

    private static AttributeDefinition getAttributeDefinition(String id, Object value) {
        Class type;
        int attrCardinality;
        if (value == null) {
            attrCardinality = 0;
            type = class$java$lang$String == null ? (class$java$lang$String = ConfigManager.class$("java.lang.String")) : class$java$lang$String;
        } else if (value instanceof Collection) {
            attrCardinality = Integer.MIN_VALUE;
            Collection coll = (Collection)value;
            type = coll.isEmpty() ? (class$java$lang$String == null ? (class$java$lang$String = ConfigManager.class$("java.lang.String")) : class$java$lang$String) : coll.iterator().next().getClass();
        } else if (value.getClass().isArray()) {
            attrCardinality = Integer.MAX_VALUE;
            type = value.getClass().getComponentType();
        } else {
            attrCardinality = 0;
            type = value.getClass();
        }
        int attrType = type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigManager.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == Boolean.TYPE ? 11 : (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConfigManager.class$("java.lang.Byte")) : class$java$lang$Byte) || type == Byte.TYPE ? 6 : (type == (class$java$lang$Character == null ? (class$java$lang$Character = ConfigManager.class$("java.lang.Character")) : class$java$lang$Character) || type == Character.TYPE ? 5 : (type == (class$java$lang$Double == null ? (class$java$lang$Double = ConfigManager.class$("java.lang.Double")) : class$java$lang$Double) || type == Double.TYPE ? 7 : (type == (class$java$lang$Float == null ? (class$java$lang$Float = ConfigManager.class$("java.lang.Float")) : class$java$lang$Float) || type == Float.TYPE ? 8 : (type == (class$java$lang$Long == null ? (class$java$lang$Long = ConfigManager.class$("java.lang.Long")) : class$java$lang$Long) || type == Long.TYPE ? 2 : (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConfigManager.class$("java.lang.Integer")) : class$java$lang$Integer) || type == Integer.TYPE ? 3 : (type == (class$java$lang$Short == null ? (class$java$lang$Short = ConfigManager.class$("java.lang.Short")) : class$java$lang$Short) || type == Short.TYPE ? 4 : 1)))))));
        return new PlaceholderAttributeDefinition(id, attrType, attrCardinality);
    }

    private static boolean isPasswordProperty(String name) {
        return name == null ? false : name.toLowerCase().indexOf("password") != -1;
    }

    private static int getAttributeType(AttributeDefinition ad) {
        if (ad.getType() == 1 && ConfigManager.isPasswordProperty(ad.getID())) {
            return 12;
        }
        return ad.getType();
    }

    private static final Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return new Character(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    private static List toList(Object value) {
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                int len = Array.getLength(value);
                Object[] tmp = new Object[len];
                for (int j = 0; j < len; ++j) {
                    tmp[j] = Array.get(value, j);
                }
                value = tmp;
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    private static void setPasswordProps(Vector vec, String[] properties, Object props) {
        List propList = ConfigManager.toList(props);
        for (int i = 0; i < properties.length; ++i) {
            if (PASSWORD_PLACEHOLDER_VALUE.equals(properties[i])) {
                if (i >= propList.size() || propList.get(i) == null) continue;
                vec.add(propList.get(i));
                continue;
            }
            vec.add(properties[i]);
        }
    }

    private static final Object toArray(int type, Vector values) {
        Object[] array;
        int size = values.size();
        if (type == 1 || type == 12) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
                break;
            }
            case 6: {
                array = new byte[size];
                break;
            }
            case 5: {
                array = new char[size];
                break;
            }
            case 7: {
                array = new double[size];
                break;
            }
            case 8: {
                array = new float[size];
                break;
            }
            case 2: {
                array = new long[size];
                break;
            }
            case 3: {
                array = new int[size];
                break;
            }
            case 4: {
                array = new short[size];
                break;
            }
            default: {
                array = new String[size];
            }
        }
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PlaceholderAttributeDefinition
    implements AttributeDefinition {
        final String id;
        final int type;
        final int cardinality;

        public PlaceholderAttributeDefinition(String id, int type, int cardinality) {
            this.id = id;
            this.type = type;
            this.cardinality = cardinality;
        }

        public String getName() {
            return this.id;
        }

        public String getID() {
            return this.id;
        }

        public String getDescription() {
            return null;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public int getType() {
            return this.type;
        }

        public String[] getOptionValues() {
            return null;
        }

        public String[] getOptionLabels() {
            return null;
        }

        public String validate(String value) {
            return null;
        }

        public String[] getDefaultValue() {
            return null;
        }
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return ConfigManager.PLACEHOLDER_PID;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary properties) {
        }

        public void delete() {
        }
    }
}

