/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class PluginHolder
implements ServiceListener {
    private final BundleContext bundleContext;
    private final Map plugins;
    private ServletContext servletContext;
    private String defaultPluginLabel;

    PluginHolder(BundleContext context) {
        this.bundleContext = context;
        this.plugins = new HashMap();
    }

    void open() {
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=javax.servlet.Servlet)");
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed registering for Servlet service events: " + ise.getMessage());
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences("javax.servlet.Servlet", null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    this.serviceAdded(refs[i]);
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new InternalError("Failed getting existing Servlet services: " + ise.getMessage());
        }
    }

    void close() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        Plugin[] plugin = this.plugins.values().toArray(new Plugin[this.plugins.size()]);
        for (int i = 0; i < plugin.length; ++i) {
            plugin[i].ungetService();
        }
        this.plugins.clear();
        this.defaultPluginLabel = null;
    }

    String getDefaultPluginLabel() {
        return this.defaultPluginLabel;
    }

    void setDefaultPluginLabel(String defaultPluginLabel) {
        this.defaultPluginLabel = defaultPluginLabel;
    }

    AbstractWebConsolePlugin getDefaultPlugin() {
        return this.getPlugin(this.defaultPluginLabel);
    }

    void addOsgiManagerPlugin(AbstractWebConsolePlugin consolePlugin) {
        String label = consolePlugin.getLabel();
        Plugin plugin = new Plugin(this, null, label);
        plugin.setTitle(consolePlugin.getTitle());
        plugin.setConsolePlugin(consolePlugin);
        this.addPlugin(label, plugin);
    }

    void removeOsgiManagerPlugin(String label) {
        this.removePlugin(label);
    }

    AbstractWebConsolePlugin getPlugin(String label) {
        if (label == null || label.length() == 0) {
            if (!this.plugins.isEmpty()) {
                return ((Plugin)this.plugins.values().iterator().next()).getConsolePlugin();
            }
        } else {
            Plugin plugin = (Plugin)this.plugins.get(label);
            if (plugin != null) {
                return plugin.getConsolePlugin();
            }
        }
        return null;
    }

    Map getLocalizedLabelMap(ResourceBundleManager resourceBundleManager, Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator pi = this.plugins.values().iterator();
        while (pi.hasNext()) {
            Plugin plugin = (Plugin)pi.next();
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            map.put(label, title);
        }
        return map;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.serviceAdded(event.getServiceReference());
                break;
            }
            case 4: {
                this.serviceRemoved(event.getServiceReference());
                break;
            }
        }
    }

    private void serviceAdded(ServiceReference serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.addPlugin(label, new Plugin(this, serviceReference, label));
        }
    }

    private void serviceRemoved(ServiceReference serviceReference) {
        String label = PluginHolder.getProperty(serviceReference, "felix.webconsole.label");
        if (label != null) {
            this.removePlugin(label);
        }
    }

    private void addPlugin(String label, Plugin plugin) {
        this.plugins.put(label, plugin);
    }

    private void removePlugin(String label) {
        Plugin oldPlugin = (Plugin)this.plugins.remove(label);
        if (oldPlugin != null) {
            oldPlugin.ungetService();
        }
    }

    static String getProperty(ServiceReference service, String propertyName) {
        Object property = service.getProperty(propertyName);
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }

    private static final class Plugin
    implements ServletConfig {
        private final PluginHolder holder;
        private final ServiceReference serviceReference;
        private final String label;
        private String title;
        private AbstractWebConsolePlugin consolePlugin;

        Plugin(PluginHolder holder, ServiceReference serviceReference, String label) {
            this.holder = holder;
            this.serviceReference = serviceReference;
            this.label = label;
        }

        final Bundle getBundle() {
            if (this.serviceReference != null) {
                return this.serviceReference.getBundle();
            }
            return this.holder.getBundleContext().getBundle();
        }

        final String getLabel() {
            return this.label;
        }

        void setTitle(String title) {
            this.title = title;
        }

        final String getTitle() {
            if (this.title == null) {
                this.title = PluginHolder.getProperty(this.serviceReference, "felix.webconsole.title");
                if (this.title == null) {
                    this.title = this.label;
                    this.acquireServlet();
                    this.title = this.consolePlugin != null ? this.consolePlugin.getTitle() : null;
                }
            }
            return this.title;
        }

        final AbstractWebConsolePlugin getConsolePlugin() {
            this.acquireServlet();
            return this.consolePlugin;
        }

        void setConsolePlugin(AbstractWebConsolePlugin service) {
            try {
                service.init(this);
                this.consolePlugin = service;
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }

        final void ungetService() {
            if (this.consolePlugin != null) {
                try {
                    this.consolePlugin.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.consolePlugin = null;
                if (this.serviceReference != null) {
                    this.holder.getBundleContext().ungetService(this.serviceReference);
                }
            }
        }

        public String getInitParameter(String name) {
            Object property;
            if (this.serviceReference != null && (property = this.serviceReference.getProperty(name)) != null && !property.getClass().isArray()) {
                return property.toString();
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            final String[] keys = this.serviceReference == null ? new String[]{} : this.serviceReference.getPropertyKeys();
            return new Enumeration(){
                int idx = 0;

                public boolean hasMoreElements() {
                    return this.idx < keys.length;
                }

                public Object nextElement() {
                    if (this.hasMoreElements()) {
                        return keys[this.idx++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public ServletContext getServletContext() {
            return this.holder.getServletContext();
        }

        public String getServletName() {
            return this.getTitle();
        }

        private void acquireServlet() {
            Object service;
            if (this.consolePlugin == null && (service = this.holder.getBundleContext().getService(this.serviceReference)) instanceof Servlet) {
                AbstractWebConsolePlugin servlet = service instanceof AbstractWebConsolePlugin ? (AbstractWebConsolePlugin)((Object)service) : new WebConsolePluginAdapter(this.label, (Servlet)service, this.serviceReference);
                this.setConsolePlugin(servlet);
            }
        }
    }
}

