/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.WebConsolePluginAdapter;
import org.apache.felix.webconsole.internal.filter.FilteringResponseWrapper;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener2;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_APP_ROOT_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".appRoot";
    private static final String ATTR_LABEL_MAP_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".labelMap";
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    static final String PROP_MANAGER_ROOT = "manager.root";
    static final String PROP_DEFAULT_RENDER = "default.render";
    static final String PROP_REALM = "realm";
    static final String PROP_USER_NAME = "username";
    static final String PROP_PASSWORD = "password";
    static final String PROP_ENABLED_PLUGINS = "plugins";
    static final String PROP_LOG_LEVEL = "loglevel";
    public static final int DEFAULT_LOG_LEVEL = 2;
    static final String DEFAULT_PAGE = "bundles";
    static final String DEFAULT_REALM = "OSGi Management Console";
    static final String DEFAULT_USER_NAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";
    static final String DEFAULT_MANAGER_ROOT = "/system/console";
    static final String[] PLUGIN_CLASSES = new String[]{"org.apache.felix.webconsole.internal.compendium.ComponentConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.ComponentsServlet", "org.apache.felix.webconsole.internal.compendium.ConfigManager", "org.apache.felix.webconsole.internal.compendium.ConfigurationAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.LogServlet", "org.apache.felix.webconsole.internal.compendium.PreferencesConfigurationPrinter", "org.apache.felix.webconsole.internal.core.BundlesServlet", "org.apache.felix.webconsole.internal.core.ServicesServlet", "org.apache.felix.webconsole.internal.deppack.DepPackServlet", "org.apache.felix.webconsole.internal.misc.LicenseServlet", "org.apache.felix.webconsole.internal.misc.ShellServlet", "org.apache.felix.webconsole.internal.misc.SystemPropertiesPrinter", "org.apache.felix.webconsole.internal.misc.ThreadPrinter", "org.apache.felix.webconsole.internal.obr.BundleRepositoryRender", "org.apache.felix.webconsole.internal.system.VMStatPlugin"};
    private BundleContext bundleContext;
    private ServiceTracker httpServiceTracker;
    private HttpService httpService;
    private ServiceTracker pluginsTracker;
    private ServiceTracker brandingTracker;
    private ServiceRegistration configurationListener;
    private Map plugins = new HashMap();
    private List osgiManagerPlugins = new ArrayList();
    private AbstractWebConsolePlugin defaultPlugin;
    private String defaultRenderName;
    private String webManagerRoot;
    private boolean httpServletRegistered;
    private boolean httpResourcesRegistered;
    private Dictionary configuration;
    private Set enabledPlugins;
    ResourceBundleManager resourceBundleManager;
    private int logLevel = 2;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$servlet$OsgiManager;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;
    static /* synthetic */ Class class$org$apache$felix$webconsole$BrandingPlugin;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.updateConfiguration(null);
        try {
            this.configurationListener = ConfigurationListener2.create(this);
        }
        catch (Throwable t2) {
            try {
                this.configurationListener = ConfigurationListener.create(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.httpServiceTracker = new HttpServiceTracker(this);
        this.httpServiceTracker.open();
    }

    public void dispose() {
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        this.defaultPlugin = null;
        this.bundleContext = null;
    }

    public void init() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            String pluginClassName = PLUGIN_CLASSES[i];
            try {
                Class<?> pluginClass = classLoader.loadClass(pluginClassName);
                Object plugin = pluginClass.newInstance();
                if (this.isPluginDisabled(pluginClassName, plugin)) {
                    this.log(3, "Ignoring plugin " + pluginClassName + ": Disabled by configuration");
                    continue;
                }
                if (plugin instanceof OsgiManagerPlugin) {
                    ((OsgiManagerPlugin)plugin).activate(this.bundleContext);
                    this.osgiManagerPlugins.add(plugin);
                }
                if (plugin instanceof AbstractWebConsolePlugin) {
                    this.bindServlet((AbstractWebConsolePlugin)((Object)plugin));
                    continue;
                }
                if (!(plugin instanceof BrandingPlugin)) continue;
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
                continue;
            }
            catch (NoClassDefFoundError ncdfe) {
                String message = ncdfe.getMessage();
                if (message == null) {
                    message = "Class definition not found (NoClassDefFoundError)";
                } else if (message.indexOf(32) < 0) {
                    message = "Class " + message + " missing";
                }
                this.log(3, pluginClassName + " not enabled. Reason: " + message);
                continue;
            }
            catch (Throwable t) {
                this.log(3, "Failed to instantiate plugin " + pluginClassName + ". Reason: " + t);
            }
        }
        this.resourceBundleManager = new ResourceBundleManager(this.getBundleContext());
        ConfigurationRender cr = new ConfigurationRender(this.resourceBundleManager);
        cr.activate(this.bundleContext);
        this.osgiManagerPlugins.add(cr);
        this.bindServlet(cr);
        this.pluginsTracker = new PluginServiceTracker(this);
        this.pluginsTracker.open();
        this.brandingTracker = new BrandingServiceTracker(this);
        this.brandingTracker.open();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String label;
        AbstractWebConsolePlugin plugin;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.defaultRenderName);
            response.sendRedirect(path);
            return;
        }
        int slash = pathInfo.indexOf("/", 1);
        if (slash < 2) {
            slash = pathInfo.length();
        }
        if ((plugin = (AbstractWebConsolePlugin)((Object)this.plugins.get(label = pathInfo.substring(1, slash)))) == null && "install".equals(label)) {
            plugin = (AbstractWebConsolePlugin)((Object)this.plugins.get(DEFAULT_PAGE));
        }
        if (plugin == null) {
            response.sendError(404);
            return;
        }
        Map labelMap = this.getLocalizedLabelMap(request.getLocale());
        req.setAttribute("felix.webconsole.labelMap", (Object)labelMap);
        req.setAttribute("felix.webconsole.appRoot", (Object)(request.getContextPath() + request.getServletPath()));
        req.setAttribute("felix.webconsole.pluginRoot", (Object)(request.getContextPath() + request.getServletPath() + '/' + label));
        req.setAttribute(ATTR_LABEL_MAP_OLD, (Object)labelMap);
        req.setAttribute(ATTR_APP_ROOT_OLD, (Object)(request.getContextPath() + request.getServletPath()));
        response = this.wrapResponse(request, response, plugin);
        plugin.service((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        if (this.resourceBundleManager != null) {
            this.resourceBundleManager.dispose();
            this.resourceBundleManager = null;
        }
        if (this.pluginsTracker != null) {
            this.pluginsTracker.close();
            this.pluginsTracker = null;
        }
        if (this.brandingTracker != null) {
            this.brandingTracker.close();
            this.brandingTracker = null;
        }
        Iterator pi = this.osgiManagerPlugins.iterator();
        while (pi.hasNext()) {
            Object plugin = pi.next();
            ((OsgiManagerPlugin)plugin).deactivate();
        }
        this.plugins.clear();
        this.osgiManagerPlugins.clear();
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    String getConfigurationPid() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void log(int level, String message) {
        if (this.logLevel >= level) {
            this.log(message);
        }
    }

    private void log(int level, String message, Throwable t) {
        if (this.logLevel >= level) {
            this.log(message, t);
        }
    }

    private HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, AbstractWebConsolePlugin plugin) {
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
        return new FilteringResponseWrapper(response, resourceBundle, (ServletRequest)request);
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        if (this.httpService != null) {
            this.log(4, "bindHttpService: Already bound to an HTTP Service, ignoring further services");
            return;
        }
        Dictionary config = this.getConfiguration();
        String realm = this.getProperty(config, PROP_REALM, DEFAULT_REALM);
        String userId = this.getProperty(config, PROP_USER_NAME, "admin");
        String password = this.getProperty(config, PROP_PASSWORD, "admin");
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, realm, userId, password);
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            this.httpServletRegistered = true;
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
            this.httpResourcesRegistered = true;
        }
        catch (Exception e) {
            this.log(1, "bindHttpService: Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        if (this.httpService != httpService) {
            this.log(4, "unbindHttpService: Ignoring unbind of an HttpService to which we are not registered");
            return;
        }
        this.httpService = null;
        if (this.httpResourcesRegistered) {
            try {
                httpService.unregister(this.webManagerRoot + "/res");
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Resources", t);
            }
            this.httpResourcesRegistered = false;
        }
        if (this.httpServletRegistered) {
            try {
                httpService.unregister(this.webManagerRoot);
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Servlet", t);
            }
            this.httpServletRegistered = false;
        }
    }

    private void bindServlet(AbstractWebConsolePlugin plugin) {
        String label = plugin.getLabel();
        String title = plugin.getTitle();
        try {
            plugin.init(this.getServletConfig());
            this.plugins.put(label, plugin);
            if (this.defaultPlugin == null) {
                this.defaultPlugin = plugin;
            } else if (label.equals(this.defaultRenderName)) {
                this.defaultPlugin = plugin;
            }
        }
        catch (ServletException se) {
            this.log(2, "Initialization of plugin '" + title + "' (" + label + ") failed; not using this plugin", se);
        }
    }

    private void unbindServlet(String label) {
        AbstractWebConsolePlugin plugin = (AbstractWebConsolePlugin)((Object)this.plugins.remove(label));
        if (plugin != null) {
            if (this.defaultPlugin == plugin) {
                this.defaultPlugin = this.plugins.isEmpty() ? null : (AbstractWebConsolePlugin)((Object)this.plugins.values().iterator().next());
            }
            plugin.destroy();
        }
    }

    private Dictionary getConfiguration() {
        return this.configuration;
    }

    synchronized void updateConfiguration(Dictionary config) {
        Object pluginValue;
        String newWebManagerRoot;
        if (config == null) {
            config = new Hashtable();
        }
        this.configuration = config;
        this.logLevel = this.getProperty(config, PROP_LOG_LEVEL, 2);
        AbstractWebConsolePlugin.setLogLevel(this.logLevel);
        this.defaultRenderName = this.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE);
        if (this.defaultRenderName != null && this.plugins.get(this.defaultRenderName) != null) {
            this.defaultPlugin = (AbstractWebConsolePlugin)((Object)this.plugins.get(this.defaultRenderName));
        }
        if (!(newWebManagerRoot = this.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT)).startsWith("/")) {
            newWebManagerRoot = "/" + newWebManagerRoot;
        }
        if ((pluginValue = ((Dictionary)config).get(PROP_ENABLED_PLUGINS)) == null) {
            this.enabledPlugins = null;
        } else if (pluginValue.getClass().isArray()) {
            Object[] names = (Object[])pluginValue;
            this.enabledPlugins = new HashSet();
            for (int i = 0; i < names.length; ++i) {
                this.enabledPlugins.add(String.valueOf(names[i]));
            }
        } else if (pluginValue instanceof Collection) {
            this.enabledPlugins = new HashSet();
            this.enabledPlugins.addAll((Collection)pluginValue);
        }
        HttpService httpService = this.httpService;
        if (httpService != null) {
            this.unbindHttpService(httpService);
            this.webManagerRoot = newWebManagerRoot;
            this.bindHttpService(httpService);
        } else {
            this.webManagerRoot = newWebManagerRoot;
        }
    }

    private String getProperty(Dictionary config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    private int getProperty(Dictionary config, String name, int def) {
        Object value = config.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return def;
    }

    private boolean isPluginDisabled(String pluginClass, Object plugin) {
        return this.enabledPlugins != null && !this.enabledPlugins.contains(pluginClass) && plugin instanceof AbstractWebConsolePlugin;
    }

    private Dictionary toStringConfig(Dictionary config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    private final Map getLocalizedLabelMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator pi = this.plugins.values().iterator();
        while (pi.hasNext()) {
            AbstractWebConsolePlugin plugin = (AbstractWebConsolePlugin)((Object)pi.next());
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = this.resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            map.put(label, title);
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BrandingServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        BrandingServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$apache$felix$webconsole$BrandingPlugin == null ? (class$org$apache$felix$webconsole$BrandingPlugin = OsgiManager.class$("org.apache.felix.webconsole.BrandingPlugin")) : class$org$apache$felix$webconsole$BrandingPlugin).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object plugin = super.addingService(reference);
            if (plugin instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
            }
            return plugin;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin(null);
            }
            super.removedService(reference, service);
        }
    }

    private static class PluginServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        PluginServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), "javax.servlet.Servlet", null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                Object operation = super.addingService(reference);
                if (operation instanceof Servlet) {
                    AbstractWebConsolePlugin plugin;
                    if (operation instanceof AbstractWebConsolePlugin) {
                        plugin = (AbstractWebConsolePlugin)((Object)operation);
                    } else {
                        Object title = reference.getProperty("felix.webconsole.title");
                        if (!(title instanceof String)) {
                            if (operation instanceof GenericServlet) {
                                title = ((GenericServlet)operation).getServletName();
                            }
                            if (!(title instanceof String)) {
                                title = operation.toString();
                            }
                        }
                        plugin = new WebConsolePluginAdapter((String)label, (String)title, (Servlet)operation, reference);
                        Bundle pluginBundle = reference.getBundle();
                        plugin.activate(pluginBundle.getBundleContext());
                    }
                    this.osgiManager.bindServlet(plugin);
                }
                return operation;
            }
            return null;
        }

        public void removedService(ServiceReference reference, Object service) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                this.osgiManager.unbindServlet((String)label);
                if (service instanceof WebConsolePluginAdapter) {
                    ((WebConsolePluginAdapter)((Object)service)).deactivate();
                }
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = OsgiManager.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)service);
            }
            return service;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

